/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.IUDDIConstants;
import electric.uddi.UDDIException;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class Name
implements ISerializable,
IUDDIConstants {
    private String text;
    private String language;

    public Name() {
        this.text = "";
    }

    public Name(String text) {
        this.text = text;
    }

    public Name(String text, String language) {
        this.text = text;
        this.language = language;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.language != null) {
            buffer.append("(xml:lang=");
            buffer.append(this.language);
            buffer.append(") ");
        }
        buffer.append(this.text);
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        if (!ArrayUtil.equals(this.language, name.language)) {
            return false;
        }
        return ArrayUtil.equals(this.text, name.text);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean hasLanguage() {
        return this.language != null;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void write(IWriter writer) throws IOException {
        IWriter name = writer.writeElement("name");
        if (this.language != null) {
            name.writeAttribute("xml:lang", this.language);
        }
        name.writeString(this.text);
    }

    public void read(IReader reader) throws IOException {
        this.text = reader.readString();
        this.language = reader.readAttributeValue("lang");
    }

    public static Name[] readList(IReader reader) throws IOException {
        IReader[] readers = reader.getReaders("name");
        Name[] names = new Name[readers.length];
        int i = 0;
        while (i < names.length) {
            names[i] = new Name();
            names[i].read(readers[i]);
            ++i;
        }
        return names;
    }

    public static void writeList(IWriter writer, Name[] names) throws IOException {
        int i = 0;
        while (i < names.length) {
            names[i].write(writer);
            ++i;
        }
    }

    public static void validate(Name[] names) throws UDDIException {
        if (names.length > 5) {
            throw new UDDIException(10030);
        }
        int i = 0;
        while (i < names.length) {
            if (names[i].getText().length() > 255) {
                throw new UDDIException(10020);
            }
            ++i;
        }
    }
}

