/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.rpc;

import electric.holder.Holders;
import electric.soap.rpc.Parameter;
import electric.util.Value;
import electric.util.classloader.ClassLoaders;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.lang.reflect.Field;

public class Out
extends Parameter {
    protected Class holderClass;
    protected Field field;

    public Out(SchemaElement element) {
        super(element);
    }

    public boolean isInput() {
        return false;
    }

    public boolean isOutput() {
        return true;
    }

    public Class getJavaClass() throws ClassNotFoundException {
        return this.getHolderClass();
    }

    public String getJavaName() throws SchemaException {
        return this.getHolderClassName();
    }

    public Object newHolder() {
        try {
            return this.getHolderClass().newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setValue(Object holder, Object value) {
        try {
            this.getField().set(holder, value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object getValue(Object holder) {
        try {
            return this.getField().get(holder);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private synchronized Field getField() {
        if (this.field != null) {
            return this.field;
        }
        try {
            this.field = Holders.getField(this.getHolderClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.field;
    }

    public String getHolderClassName() throws SchemaException {
        return Holders.getOutHolderClassName(this.getType().getJavaName());
    }

    public synchronized Class getHolderClass() throws ClassNotFoundException {
        if (this.holderClass != null) {
            return this.holderClass;
        }
        try {
            this.holderClass = ClassLoaders.loadClass(this.getHolderClassName());
            return this.holderClass;
        }
        catch (SchemaException exception) {
            throw new ClassNotFoundException(exception.toString());
        }
    }

    public Object getRawObject(Object object) {
        return this.getValue(object);
    }

    public Object valueOf(String string) throws IOException {
        return this.newHolder();
    }

    public Object valueOf(Object[] args) {
        return this.newHolder();
    }

    public void writeRequest(IWriter writer, Object object) throws IOException {
    }

    public void writeResponse(IWriter writer, Object object) throws IOException {
        writer.writeObject(this.element, this.getValue(object));
    }

    public Value readResponse(IReader reader, Object object) throws IOException {
        Value value = new Value();
        this.element.readObject(reader, value);
        this.setValue(object, value.object);
        return value;
    }

    public Value readRequest(IReader reader) throws IOException {
        return new Value(this.newHolder());
    }
}

