/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.filters;

import electric.glue.IGLUELoggingConstants;
import electric.servlet.HTTPContext;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

public final class ServletFilterConfig
implements FilterConfig,
IGLUELoggingConstants {
    private HTTPContext context;
    private String name;
    private String className;
    private Hashtable parameters = new Hashtable();
    private Filter filter;

    public ServletFilterConfig(HTTPContext context, String name, String className) {
        this.context = context;
        this.name = name;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public Hashtable getInitParameters() {
        return this.parameters;
    }

    public String getInitParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.parameters.keys();
    }

    public void addInitParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public void removeInitParameter(String key) {
        this.parameters.remove(key);
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getFilterName() {
        return this.name;
    }

    public synchronized Filter getFilter() {
        block2: {
            if (this.filter != null) break block2;
            try {
                this.filter = (Filter)this.context.loadClass(this.className).newInstance();
                this.filter.init((FilterConfig)this);
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.CONFIG_EVENT)) break block2;
                Log.log(ILoggingConstants.CONFIG_EVENT, "problem creating filter class:" + this.className, exception);
            }
        }
        return this.filter;
    }

    public String toString() {
        return "ServletFilterConfig@" + Integer.toHexString(this.hashCode()) + "(" + this.name + "," + this.className + ")";
    }
}

