/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms;

import electric.glue.IGLUELoggingConstants;
import electric.server.jms.IJMSAdapter;
import electric.server.jms.IJMSConstants;
import electric.server.jms.JMSAdapters;
import electric.server.jms.JMSContext;
import electric.server.jms.JMSDispatcher;
import electric.server.jms.JMSResourceLoader;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.jms.JMSUtil;
import electric.util.license.Enabler;
import electric.util.license.License;
import electric.util.license.LicensingException;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;
import electric.util.resourceloader.ResourceLoaders;
import electric.util.string.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueRequestor;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public final class JMS
implements IJMSConstants,
IGLUELoggingConstants {
    private static boolean enabled = false;
    private static boolean allowEnable = true;
    private static final String DEFAULTADAPTER = "electric.server.jms.BasicJNDIAdapter";
    private static JMSDispatcher dispatcher = new JMSDispatcher();
    private static String defaultAdapter = "electric.server.jms.BasicJNDIAdapter";
    private static IJMSAdapter jmsAdapter;
    private static Hashtable connections;
    private static QueueSession[] sessions;
    private static MessageConsumer[] consumers;
    private static MessageProducer[] producers;
    private static QueueRequestor[] requestors;

    public static void initialize() {
        ResourceLoaders.addResourceLoader("jms", new JMSResourceLoader());
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("JMS cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"JMS integration feature disabled");
    }

    public static JMSContext startup(String application) throws JMSException, NamingException, MalformedURLException {
        return JMS.startup(application, "/");
    }

    public static JMSContext startup(String application, Context context) throws JMSException, NamingException, MalformedURLException {
        return JMS.startup(application, "/", context);
    }

    public static JMSContext startup(String application, String path) throws JMSException, NamingException, MalformedURLException {
        XURL xurlApplication = new XURL(application);
        JMS.checkNamespace(xurlApplication);
        String appPath = xurlApplication.getFile();
        Context context = new Context();
        context.addProperty("jmsQueue", Strings.splice("GlueQueue", appPath));
        context.addProperty("jmsQueueConnectionFactory", Strings.splice("GlueQueueConnectionFactory", appPath));
        return JMS.startup(application, path, context);
    }

    public static JMSContext startup(String application, String path, Context context) throws JMSException, NamingException, MalformedURLException {
        Product.startupAsServer();
        JMS.checkLicense();
        jmsAdapter = JMS.getAdapter();
        XURL xurlApplication = new XURL(application);
        JMS.checkNamespace(xurlApplication);
        jmsAdapter.startup(context);
        String queueName = context.getStringProperty("jmsQueue");
        String queueFact = context.getStringProperty("jmsQueueConnectionFactory");
        if (queueName == null && queueFact == null) {
            queueName = Strings.splice("GlueQueue", xurlApplication.getFile());
            queueFact = Strings.splice("GlueQueueConnectionFactory", xurlApplication.getFile());
        } else {
            String genericMessage = "either specify all settings (request/response queue and connection factory) or accept the defaults";
            if (queueName == null) {
                throw new JMSException("queue name is not set. " + genericMessage);
            }
            if (queueFact == null) {
                throw new JMSException("queue connection factory is not set. " + genericMessage);
            }
        }
        Object cacheCnxProp = Context.getProperty(context, "jmsReuseJMSQueueConnections");
        boolean cacheCnx = cacheCnxProp == null || !cacheCnxProp.equals("no");
        QueueConnectionFactory qConnFactory = jmsAdapter.getQueueConnectionFactory(queueFact, true);
        QueueConnection qConnection = JMS.getQConnection(qConnFactory, cacheCnx);
        Queue queue = jmsAdapter.getQueue(queueName, true);
        QueueSession qSession = JMS.createQSession(qConnection);
        JMSContext jmsContext = new JMSContext(xurlApplication, path, qConnection, qSession, queue, queueName, queueFact);
        dispatcher.startDispatch(jmsContext);
        if (jmsAdapter != null) {
            System.out.println("using " + jmsAdapter.getProviderName() + " JMS provider");
        }
        return jmsContext;
    }

    public static void shutdown() {
        JMS.clearMessageRequestors();
        JMS.clearMessageConsumers();
        JMS.clearMessageProducers();
        JMS.clearSessions();
        JMS.clearConnections();
        JMS.cleanup();
    }

    private static void clearMessageRequestors() {
        if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
            Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("closing " + requestors.length + " requestor(s)"));
        }
        int i = 0;
        while (i < requestors.length) {
            block5: {
                try {
                    requestors[i].close();
                }
                catch (JMSException exception) {
                    if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                        Log.log(ILoggingConstants.ERROR_EVENT, (Object)"error closing JMS queue requestor.");
                    }
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
            }
            ++i;
        }
        requestors = new QueueRequestor[0];
    }

    private static void clearMessageConsumers() {
        if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
            Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("closing " + consumers.length + " consumer(s)"));
        }
        int i = 0;
        while (i < consumers.length) {
            block5: {
                try {
                    consumers[i].close();
                }
                catch (JMSException exception) {
                    if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                        Log.log(ILoggingConstants.ERROR_EVENT, (Object)"error while JMS message consumer. ");
                    }
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
            }
            ++i;
        }
        consumers = new MessageConsumer[0];
    }

    private static void clearMessageProducers() {
        if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
            Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("closing " + producers.length + " producer(s)"));
        }
        int i = 0;
        while (i < producers.length) {
            block5: {
                try {
                    producers[i].close();
                }
                catch (JMSException exception) {
                    if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                        Log.log(ILoggingConstants.ERROR_EVENT, (Object)"error closing JMS message consumer.");
                    }
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
            }
            ++i;
        }
        producers = new MessageProducer[0];
    }

    private static void clearSessions() {
        if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
            Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("closing " + sessions.length + " session(s)"));
        }
        int i = 0;
        while (i < sessions.length) {
            block5: {
                try {
                    sessions[i].close();
                }
                catch (JMSException exception) {
                    if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                        Log.log(ILoggingConstants.ERROR_EVENT, (Object)"error closing JMS queue session.");
                    }
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block5;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
            }
            ++i;
        }
        sessions = new QueueSession[0];
    }

    private static void clearConnections() {
        if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
            Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)"closing connections for all connection factories");
        }
        Enumeration cnxEnum = connections.elements();
        while (cnxEnum.hasMoreElements()) {
            QueueConnection[] conxs = (QueueConnection[])cnxEnum.nextElement();
            if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("closing " + conxs.length + " connection(s)"));
            }
            int i = 0;
            while (i < conxs.length) {
                block7: {
                    try {
                        conxs[i].stop();
                        conxs[i].close();
                    }
                    catch (JMSException exception) {
                        if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                            Log.log(ILoggingConstants.ERROR_EVENT, (Object)"error while closing JMS queue connection.");
                        }
                        if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block7;
                        Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                    }
                }
                ++i;
            }
        }
        connections.clear();
    }

    private static void cleanup() {
        block8: {
            block7: {
                try {
                    JMSUtil.cleanup();
                }
                catch (Exception exception) {
                    if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                        Log.log(ILoggingConstants.ERROR_EVENT, (Object)"error closing JNDI context.");
                    }
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block7;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
            }
            try {
                if (jmsAdapter != null) {
                    jmsAdapter.shutdown();
                }
            }
            catch (Exception exception) {
                if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                    Log.log(ILoggingConstants.ERROR_EVENT, (Object)"error closing JMS admin.");
                }
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block8;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
        }
    }

    public static synchronized void registerAdapter(String jmsAdapterClassName) {
        block9: {
            if (jmsAdapter != null) {
                return;
            }
            try {
                Object adapterObject = ClassLoaders.loadClass(jmsAdapterClassName).newInstance();
                if (!(adapterObject instanceof IJMSAdapter)) {
                    System.out.println(jmsAdapterClassName + " does not implement electric.server.jms.IJMSAdapter. class cannot be registered");
                    return;
                }
                jmsAdapter = (IJMSAdapter)adapterObject;
            }
            catch (ClassNotFoundException exception) {
            }
            catch (NoClassDefFoundError exception) {
            }
            catch (InstantiationException exception) {
                System.out.println("unable to create an instance of " + jmsAdapterClassName + ". make sure the class has a default no arg constructor");
                return;
            }
            catch (IllegalAccessException exception) {
                System.out.println("unable to create an instance of " + jmsAdapterClassName + ". make sure the the default no arg constructor has public access modifier");
                return;
            }
            if (jmsAdapter == null) break block9;
            String className = jmsAdapter.getClassName();
            try {
                ClassLoaders.loadClass(className);
            }
            catch (ClassNotFoundException exception) {
                jmsAdapter = null;
            }
        }
    }

    public static IJMSAdapter getAdapter() {
        if (jmsAdapter != null) {
            return jmsAdapter;
        }
        String[] adapters = JMSAdapters.getAdapters();
        int i = 0;
        while (i < adapters.length) {
            JMS.registerAdapter(adapters[i]);
            ++i;
        }
        if (jmsAdapter == null) {
            JMS.registerAdapter(defaultAdapter);
        }
        return jmsAdapter;
    }

    public static void setDefaultAdapter(String defaultAdapter) {
        if (defaultAdapter == null) {
            throw new NullPointerException("default adapter cannot be null");
        }
        JMS.defaultAdapter = defaultAdapter;
    }

    public static String getDefaultAdapter() {
        return defaultAdapter;
    }

    public static synchronized QueueConnection getQConnection(QueueConnectionFactory qConnFactory, boolean cacheCnx) throws JMSException {
        QueueConnection qConn;
        if (cacheCnx) {
            if (connections.containsKey(qConnFactory)) {
                QueueConnection[] connArray = (QueueConnection[])connections.get(qConnFactory);
                qConn = connArray[(int)Math.round(Math.random() * (double)(connArray.length - 1))];
            } else {
                QueueConnection[] connArray = new QueueConnection[]{};
                qConn = qConnFactory.createQueueConnection();
                connArray = (QueueConnection[])ArrayUtil.addElement(connArray, qConn);
                connections.put(qConnFactory, connArray);
            }
        } else {
            QueueConnection[] connArray = (QueueConnection[])connections.get(qConnFactory);
            if (connArray == null) {
                connArray = new QueueConnection[]{};
            }
            qConn = qConnFactory.createQueueConnection();
            connArray = (QueueConnection[])ArrayUtil.addElement(connArray, qConn);
            connections.put(qConnFactory, connArray);
        }
        return qConn;
    }

    public static synchronized QueueSession createQSession(QueueConnection qConn) throws JMSException {
        QueueSession session = qConn.createQueueSession(false, 1);
        sessions = (QueueSession[])ArrayUtil.addElement(sessions, session);
        return session;
    }

    public static synchronized QueueReceiver createReceiver(QueueSession qSession, Queue queue) throws JMSException {
        return JMS.createReceiver(qSession, queue, null);
    }

    public static synchronized QueueReceiver createReceiver(QueueSession qSession, Queue queue, String selector) throws JMSException {
        QueueReceiver receiver = selector == null ? qSession.createReceiver(queue) : qSession.createReceiver(queue, selector);
        consumers = (MessageConsumer[])ArrayUtil.addElement(consumers, receiver);
        return receiver;
    }

    public static synchronized QueueSender createSender(QueueSession qSession, Queue queue) throws JMSException {
        QueueSender sender = qSession.createSender(queue);
        producers = (MessageProducer[])ArrayUtil.addElement(producers, sender);
        return sender;
    }

    public static synchronized QueueRequestor createRequestor(QueueSession qSession, Queue queue) throws JMSException {
        QueueRequestor requestor = new QueueRequestor(qSession, queue);
        requestors = (QueueRequestor[])ArrayUtil.addElement(requestors, requestor);
        return requestor;
    }

    public static String[] findAdminObjects(String requestQueueName, String queueConnFactName, String servicePath) throws IOException {
        boolean defaultObj;
        boolean bl = defaultObj = requestQueueName == null;
        if (servicePath.equals("")) {
            servicePath = "/";
        }
        String path = servicePath;
        jmsAdapter = JMS.getAdapter();
        while (true) {
            if (defaultObj) {
                requestQueueName = Strings.splice("GlueQueue", servicePath);
                queueConnFactName = Strings.splice("GlueQueueConnectionFactory", servicePath);
            }
            try {
                jmsAdapter.getQueueConnectionFactory(queueConnFactName, false);
                jmsAdapter.getQueue(requestQueueName, false);
            }
            catch (NameNotFoundException exception) {
                if (!defaultObj) {
                    throw new IOException("jndi lookup failed - " + exception.toString());
                }
                if (servicePath.equals("/")) {
                    throw new IOException("jndi lookup failed. unable to locate queue and queue connection factory for " + path);
                }
                if (!(servicePath = Strings.getEndpoint(servicePath)).equals("")) continue;
                servicePath = "/";
                continue;
            }
            catch (NamingException exception) {
                throw new IOException("jndi lookup failed. unable to locate queue and queue connection factory for " + path + " " + exception.toString());
            }
            catch (JMSException exception) {
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
                throw new IOException("unexpected JMS exception - " + exception.toString());
            }
            break;
        }
        if (servicePath.startsWith("/")) {
            servicePath.substring(1);
        }
        if (servicePath.endsWith("/")) {
            servicePath.substring(0, servicePath.length() - 1);
        }
        return new String[]{queueConnFactName, requestQueueName, servicePath};
    }

    private static void checkNamespace(XURL xurlNamespace) throws MalformedURLException {
        if (xurlNamespace.getProtocol() == null || !xurlNamespace.getProtocol().equalsIgnoreCase("jms")) {
            throw new MalformedURLException("invalid protocol namespace protocol. the namespace must start with jms:///");
        }
        if (!xurlNamespace.getHost().equals("")) {
            throw new MalformedURLException("invalid namespace format. namespace must start with jms:///");
        }
    }

    private static void checkLicense() {
        if (!JMS.isEnabled()) {
            throw new IllegalStateException("JMS feature is disabled. Contact TME Sales to obtain GLUE Professional license.");
        }
        if (License.isClientLicense()) {
            throw new LicensingException("soap/jms server is disabled. Contact TME Sales to obtain a server side license");
        }
    }

    static {
        connections = new Hashtable();
        sessions = new QueueSession[0];
        consumers = new MessageConsumer[0];
        producers = new MessageProducer[0];
        requestors = new QueueRequestor[0];
        Product.startup();
    }
}

