/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.nodes.liveness;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.logs.LogEntry;
import electric.fabric.logs.LogManagerException;
import electric.fabric.nodes.NodeInfo;
import electric.soap.SOAPMessage;
import electric.soap.references.ISOAPReference;
import electric.util.Context;
import electric.util.thread.ThreadPool;
import electric.util.time.TimeUtil;
import electric.xdb.Data;
import electric.xdb.IActiveData;
import electric.xdb.IXDBConstants;
import electric.xdb.Query;
import electric.xdb.XDBException;
import electric.xdb.server.IXDBServer;
import electric.xml.Element;
import java.rmi.RemoteException;

public class NodeLiveness
implements IActiveData,
Runnable,
IFabricConstants,
IXDBConstants {
    private static long livenessCycle = 30000L;
    private static long reapThreshold = 100000L;
    private static final SOAPMessage ping = NodeLiveness.getPingMessage();
    private transient IXDBServer server;
    private transient boolean stop;
    private transient long currentTime;
    private transient long lastTime;

    public static void setReapThreshold(long reapThreshold) {
        NodeLiveness.reapThreshold = reapThreshold;
    }

    public static long getReapThreshold() {
        return reapThreshold;
    }

    public boolean isMany() {
        return false;
    }

    public void activate(IXDBServer server) {
        this.server = server;
        ThreadPool.getShared().run(this);
    }

    public void deactivate(IXDBServer server) {
        this.stop = true;
    }

    public static void setLivenessCycle(long milliseconds) {
        livenessCycle = milliseconds;
    }

    public static long getLivenessCycle() {
        return livenessCycle;
    }

    public void run() {
        this.stop = false;
        while (!this.stop) {
            this.currentTime = TimeUtil.now();
            this.checkLiveness();
            this.lastTime = this.currentTime;
            try {
                Thread.sleep(livenessCycle);
            }
            catch (InterruptedException exception) {
                // empty catch block
            }
        }
    }

    private void checkLiveness() {
        try {
            Fabric.getLogManager().addLogEntry(new LogEntry("Ping Nodes for Liveness", "SYSTEM"));
        }
        catch (LogManagerException exception) {
            // empty catch block
        }
        Element envelope = new Element("Envelope");
        Element body = envelope.addElement("Body");
        body.addElement("NodeInfo");
        Query query = new Query(envelope);
        Data[] matches = null;
        try {
            matches = this.server.getDataForQuery(query);
        }
        catch (XDBException exception) {
            return;
        }
        int i = 0;
        while (i < matches.length) {
            try {
                this.checkNode((NodeInfo)matches[i].getObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private void checkNode(NodeInfo nodeInfo) {
        if (nodeInfo.isOnline()) {
            this.checkOnlineNode(nodeInfo);
        } else {
            this.checkOfflineNode(nodeInfo);
        }
    }

    private void checkOnlineNode(NodeInfo nodeInfo) {
        try {
            this.ping(nodeInfo);
        }
        catch (RemoteException exception) {
            this.updateNodeInfo(nodeInfo, false);
        }
        catch (Exception exception) {}
    }

    private void ping(NodeInfo nodeInfo) throws Exception {
        ISOAPReference soapReference = nodeInfo.getSOAPReference();
        Context messageContext = new Context();
        soapReference.handle(ping, messageContext);
    }

    private void checkOfflineNode(NodeInfo nodeInfo) {
        block4: {
            block3: {
                if (this.currentTime - nodeInfo.getSince() <= reapThreshold) break block3;
                this.removeNodeInfo(nodeInfo);
                break block4;
            }
            if (!this.shouldPing(nodeInfo)) break block4;
            try {
                this.ping(nodeInfo);
                this.updateNodeInfo(nodeInfo, true);
            }
            catch (RemoteException exception) {
            }
            catch (Exception exception) {}
        }
    }

    private void removeNodeInfo(NodeInfo nodeInfo) {
        try {
            Fabric.getNodeManager().removeNodeInfo(nodeInfo.getURL());
        }
        catch (Exception exception) {}
    }

    private void updateNodeInfo(NodeInfo nodeInfo, boolean online) {
        NodeInfo newNodeInfo = new NodeInfo(nodeInfo);
        newNodeInfo.setOnline(online);
        newNodeInfo.setSince(this.currentTime);
        Data data = new Data(newNodeInfo.getURL(), (Object)newNodeInfo);
        try {
            this.server.addData(data);
        }
        catch (XDBException exception) {}
    }

    private boolean shouldPing(NodeInfo nodeInfo) {
        long time = nodeInfo.getSince();
        int cycles = 1;
        while (time + livenessCycle * (long)cycles <= this.currentTime) {
            time += livenessCycle * (long)cycles;
            cycles *= 2;
        }
        return time > this.lastTime;
    }

    private static SOAPMessage getPingMessage() {
        SOAPMessage ping = new SOAPMessage();
        ping.addMIMEHeader("SOAPAction", "\"\"");
        ping.addBody().addElement("livenessPing");
        return ping;
    }
}

