/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.manager;

import electric.cluster.IClusterConstants;
import electric.cluster.manager.IClusterManager;
import electric.cluster.manager.WarFileReaper;
import electric.cluster.server.AppServerInfo;
import electric.cluster.server.ApplicationServer;
import electric.cluster.server.IApplicationServer;
import electric.glue.IGLUELoggingConstants;
import electric.util.array.ArrayUtil;
import electric.util.jar.Jar;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.thread.Task;
import electric.util.thread.Tasks;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class ClusterManager
implements IClusterManager,
IClusterConstants,
IGLUELoggingConstants {
    private String applicationsRoot;
    private IApplicationServer server;
    private AppServerInfo serverInfo;

    public ClusterManager(String root, IApplicationServer server) {
        this.applicationsRoot = root.endsWith(File.separator) ? root : root + File.separator;
        this.server = server;
        this.serverInfo = new AppServerInfo();
        this.initReaper();
    }

    private void initReaper() {
        WarFileReaper runnable = new WarFileReaper(this.applicationsRoot);
        Task task = new Task(runnable, "warFileReaper", 0L, 0L, 60000L, true);
        Tasks.getShared().add(task);
    }

    public AppServerInfo getServerSnapshot(String signature) {
        return this.synchronize(signature);
    }

    private AppServerInfo synchronize(String signature) {
        String[] missingApps = new String[]{};
        String[] orphanedApps = new String[]{};
        Object[] masterApplications = this.server.listApplications();
        if (signature == null || signature.equals("null") || signature.length() == 0) {
            this.serverInfo.setMissingApplications((String[])masterApplications);
            this.serverInfo.setOrphanedApplications(orphanedApps);
            this.serverInfo.setDeletedApplications(new String[0]);
            return this.serverInfo;
        }
        StringTokenizer slaveApplications = new StringTokenizer(signature, "|");
        while (slaveApplications.hasMoreTokens()) {
            String slaveApplication = slaveApplications.nextToken();
            int i = 0;
            while (i < masterApplications.length) {
                if (!masterApplications[i].equalsIgnoreCase(slaveApplication)) {
                    if (signature.toLowerCase().indexOf(masterApplications[i].toLowerCase()) == -1) {
                        missingApps = (String[])ArrayUtil.addElement(missingApps, masterApplications[i]);
                    } else if (!ArrayUtil.contains(slaveApplication, masterApplications)) {
                        orphanedApps = (String[])ArrayUtil.addElement(orphanedApps, slaveApplication);
                    }
                }
                ++i;
            }
        }
        this.serverInfo.setMissingApplications(missingApps);
        this.serverInfo.setOrphanedApplications(orphanedApps);
        this.serverInfo.setDeletedApplications(this.server.getDeletedApplications());
        return this.serverInfo;
    }

    public MIMEData downloadApplication(String applicationName) throws IOException {
        String absolutePath = this.applicationsRoot + applicationName;
        File warFile = new File(absolutePath + ".war");
        if (!warFile.exists()) {
            Jar.jarDirectory(absolutePath, absolutePath, warFile);
        }
        return new MIMEData(warFile);
    }

    public boolean uploadApplication(String applicationName, MIMEData warFile) {
        String applicationFile = applicationName + ".war";
        try {
            File file = new File(ApplicationServer.getApplicationsRoot() + applicationFile);
            FileOutputStream fileStream = new FileOutputStream(file);
            BufferedOutputStream outputStream = new BufferedOutputStream(fileStream);
            outputStream.write(warFile.getBytes());
            outputStream.flush();
            outputStream.close();
            return true;
        }
        catch (IOException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception retrieving remote application: " + applicationName, exception);
            }
            return false;
        }
    }

    public boolean needUpdate(String signature) {
        if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("checking if remote node needs to be updated with signature " + signature));
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("signature of master server " + this.server.getApplicationSignature()));
        }
        Object[] masterApplications = this.server.listApplications();
        if (signature == null || signature.length() == 0) {
            return masterApplications.length != 0;
        }
        StringTokenizer applications = new StringTokenizer(signature, "|");
        while (applications.hasMoreTokens()) {
            if (masterApplications.length == 0) {
                return true;
            }
            String clientApplication = applications.nextToken();
            int i = 0;
            while (i < masterApplications.length) {
                if (!ArrayUtil.contains(clientApplication, masterApplications) || signature.toLowerCase().indexOf(((String)masterApplications[i]).toLowerCase()) == -1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void removeApplication(String applicationName) {
        this.server.deleteApplication(new File(ApplicationServer.getApplicationsRoot() + applicationName));
    }

    public void livenessPing() {
    }
}

