/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.jsp.jstl.sql.Result;

public class ResultImpl
implements Result {
    private List rowMap = new ArrayList();
    private List rowByIndex = new ArrayList();
    private String[] columnNames;
    private boolean isLimited;

    public ResultImpl(ResultSet rs, int startRow, int maxRows) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int noOfColumns = rsmd.getColumnCount();
        this.columnNames = new String[noOfColumns];
        int i = 1;
        while (i <= noOfColumns) {
            this.columnNames[i - 1] = rsmd.getColumnName(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < startRow) {
            rs.next();
            ++i2;
        }
        int processedRows = 0;
        while (rs.next()) {
            if (maxRows != -1 && processedRows == maxRows) {
                this.isLimited = true;
                break;
            }
            Object[] columns = new Object[noOfColumns];
            TreeMap<String, Object> columnMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            int i3 = 1;
            while (i3 <= noOfColumns) {
                Object value = rs.getObject(i3);
                if (rs.wasNull()) {
                    value = null;
                }
                columns[i3 - 1] = value;
                columnMap.put(this.columnNames[i3 - 1], value);
                ++i3;
            }
            this.rowMap.add(columnMap);
            this.rowByIndex.add(columns);
            ++processedRows;
        }
    }

    public ResultImpl(List listOfMaps) {
        this.isLimited = false;
        HashSet keySet = new HashSet();
        Iterator iter = listOfMaps.iterator();
        while (iter.hasNext()) {
            Map row = (Map)iter.next();
            keySet.addAll(row.keySet());
        }
        int noOfColumns = keySet.size();
        this.columnNames = new String[noOfColumns];
        int i = 0;
        Iterator iter2 = keySet.iterator();
        while (iter2.hasNext()) {
            this.columnNames[i] = (String)iter2.next();
            ++i;
        }
        Iterator iter3 = listOfMaps.iterator();
        while (iter3.hasNext()) {
            Map row = (Map)iter3.next();
            Object[] columns = new Object[noOfColumns];
            TreeMap columnMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            i = 0;
            while (i < noOfColumns) {
                String columnName = this.columnNames[i];
                Object value = row.get(columnName);
                columns[i] = value;
                columnMap.put(columnName, value);
                ++i;
            }
            this.rowMap.add(columnMap);
            this.rowByIndex.add(columns);
        }
    }

    public SortedMap[] getRows() {
        if (this.rowMap == null) {
            return null;
        }
        return this.rowMap.toArray(new SortedMap[0]);
    }

    public Object[][] getRowsByIndex() {
        if (this.rowByIndex == null) {
            return null;
        }
        return (Object[][])this.rowByIndex.toArray((T[])new Object[0][0]);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int getRowCount() {
        if (this.rowMap == null) {
            return -1;
        }
        return this.rowMap.size();
    }

    public boolean isLimitedByMaxRows() {
        return this.isLimited;
    }
}

