/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.query.entity;

import com.atlassian.crowd.search.query.entity.PropertyTypeService;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeServiceImpl
implements PropertyTypeService {
    private final Map<String, Class> propertyTypeMap;

    public PropertyTypeServiceImpl(Map<String, Class> propertyTypeMap) {
        this.propertyTypeMap = ImmutableMap.copyOf(propertyTypeMap);
    }

    @Override
    public Class getType(String name) {
        return this.propertyTypeMap.get(name);
    }

    public static PropertyTypeServiceImpl newInstance(Iterable<Property<?>> properties) {
        HashMap propertyTypeMap = Maps.newHashMap();
        for (Property<?> property : properties) {
            propertyTypeMap.put(property.getPropertyName(), property.getPropertyType());
        }
        return new PropertyTypeServiceImpl(propertyTypeMap);
    }
}

