/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.objectweb.carol.cmi.ClusterId;
import org.objectweb.carol.cmi.ClusterStub;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.util.configuration.TraceCarol;

class GlobalExports {
    private HashMap table = new HashMap();

    public synchronized void put(ClusterId serverId, Serializable key, Remote stub, int factor) throws RemoteException {
        ClusterStubData csd = (ClusterStubData)this.table.get(key);
        if (csd == null) {
            csd = new ClusterStubData(serverId, stub, factor);
            this.table.put(key, csd);
        } else if (!csd.setStub(serverId, stub, factor) && TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("Warning: Object registered in the cluster as two distinct types");
        }
    }

    public synchronized void remove(ClusterId serverId, Serializable key) {
        ClusterStubData csd = (ClusterStubData)this.table.get(key);
        if (csd == null) {
            return;
        }
        if (csd.removeStub(serverId)) {
            return;
        }
        this.table.remove(key);
    }

    public synchronized void zapExports(ClusterId serverId) {
        Iterator i = this.table.values().iterator();
        while (i.hasNext()) {
            ClusterStubData csd = (ClusterStubData)i.next();
            if (csd.removeStub(serverId)) continue;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStub getClusterStub(Serializable key) throws RemoteException {
        GlobalExports globalExports = this;
        synchronized (globalExports) {
            ClusterStubData csd = (ClusterStubData)this.table.get(key);
            if (csd == null) {
                return null;
            }
            return csd.getClusterStub();
        }
    }

    public synchronized Set keySet() {
        HashSet s = new HashSet();
        Iterator it = this.table.keySet().iterator();
        while (it.hasNext()) {
            s.add(it.next());
        }
        return s;
    }
}

