/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantLifecycleAware;
import com.atlassian.multitenant.MultiTenantLifecycleController;
import com.atlassian.multitenant.MultiTenantManager;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import com.atlassian.multitenant.servlet.MultiTenantServletFilter;
import com.atlassian.util.concurrent.Sink;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiTenantManager
implements MultiTenantManager,
MultiTenantLifecycleController {
    private static final Logger log = Logger.getLogger(DefaultMultiTenantManager.class);
    private final MultiTenantDatastore datastore;
    private final TenantReference tenantReference;
    private final boolean singleTenantMode;
    private final List<WeakReference<MultiTenantLifecycleAware>> listeners = new CopyOnWriteArrayList<WeakReference<MultiTenantLifecycleAware>>();
    private final List<Tenant> startedTenants = new CopyOnWriteArrayList<Tenant>();

    public DefaultMultiTenantManager(MultiTenantDatastore datastore, TenantReference tenantReference, boolean singleTenantMode) {
        this.datastore = datastore;
        this.tenantReference = tenantReference;
        this.singleTenantMode = singleTenantMode;
    }

    @Override
    public void runForEachTenant(Runnable runnable, boolean override) {
        for (Tenant tenant : this.startedTenants) {
            this.runForTenant(tenant, runnable, override);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runForTenant(Tenant tenant, Runnable runnable, boolean override) {
        this.tenantReference.set(tenant, override);
        try {
            runnable.run();
        }
        finally {
            this.tenantReference.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T callForTenant(Tenant tenant, Callable<T> callable, boolean override) throws Exception {
        this.tenantReference.set(tenant, override);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.tenantReference.remove();
        }
    }

    @Override
    public void registerListener(MultiTenantLifecycleAware lifecycleListener) {
        this.listeners.add(new WeakReference<MultiTenantLifecycleAware>(lifecycleListener));
    }

    @Override
    public void deregisterListener(MultiTenantLifecycleAware lifecycleListener) {
        for (WeakReference<MultiTenantLifecycleAware> listener : this.listeners) {
            MultiTenantLifecycleAware hardListener = (MultiTenantLifecycleAware)listener.get();
            if (hardListener != null) {
                if (!hardListener.equals(lifecycleListener)) continue;
                this.listeners.remove(listener);
                continue;
            }
            this.listeners.remove(listener);
        }
    }

    @Override
    public synchronized void addTenant(Tenant tenant) {
        this.datastore.addTenant(tenant);
        this.startTenant(tenant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startTenant(final Tenant tenant) {
        this.startedTenants.add(tenant);
        try {
            this.tenantReference.set(tenant, true);
            this.runForEachListener(new Sink<MultiTenantLifecycleAware>(){

                public void consume(MultiTenantLifecycleAware listener) {
                    listener.onTenantStart(tenant);
                }
            }, true);
        }
        finally {
            try {
                this.tenantReference.remove();
            }
            catch (IllegalStateException ise) {
                log.error((Object)ise);
            }
        }
    }

    @Override
    public synchronized void removeTenant(String tenantName) {
        Tenant tenant = this.datastore.get(tenantName);
        this.datastore.removeTenant(tenant);
        this.stopTenant(tenant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopTenant(final Tenant tenant) {
        try {
            this.tenantReference.set(tenant, true);
            this.runForEachListener(new Sink<MultiTenantLifecycleAware>(){

                public void consume(MultiTenantLifecycleAware listener) {
                    try {
                        listener.onTenantStop(tenant);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error stopping listener", (Throwable)e);
                    }
                }
            }, false);
        }
        finally {
            try {
                this.tenantReference.remove();
            }
            catch (IllegalStateException ise) {
                log.error((Object)ise);
            }
        }
        this.startedTenants.remove(tenant);
    }

    @Override
    public synchronized void refreshTenant(Tenant tenant) {
        this.stopTenant(tenant);
        this.startTenant(tenant);
    }

    @Override
    public void startAll() {
        for (Tenant tenant : this.datastore.getAll()) {
            this.startTenant(tenant);
        }
    }

    @Override
    public void stopAll() {
        for (Tenant tenant : this.startedTenants) {
            this.stopTenant(tenant);
        }
    }

    private void runForEachListener(Sink<MultiTenantLifecycleAware> consumer, boolean forward) {
        Iterator<WeakReference<MultiTenantLifecycleAware>> iterator;
        if (forward) {
            iterator = this.listeners.iterator();
        } else {
            final ListIterator<WeakReference<MultiTenantLifecycleAware>> listIterator = this.listeners.listIterator(this.listeners.size());
            iterator = new Iterator<WeakReference<MultiTenantLifecycleAware>>(){

                @Override
                public boolean hasNext() {
                    return listIterator.hasPrevious();
                }

                @Override
                public WeakReference<MultiTenantLifecycleAware> next() {
                    return (WeakReference)listIterator.previous();
                }

                @Override
                public void remove() {
                    listIterator.remove();
                }
            };
        }
        while (iterator.hasNext()) {
            WeakReference<MultiTenantLifecycleAware> listener = iterator.next();
            MultiTenantLifecycleAware hardListener = (MultiTenantLifecycleAware)listener.get();
            if (hardListener != null) {
                consumer.consume((Object)hardListener);
                continue;
            }
            this.listeners.remove(listener);
        }
    }

    @Override
    public boolean isSingleTenantMode() {
        return this.singleTenantMode;
    }

    @Override
    public Collection<Tenant> getAllTenants() {
        return Collections.unmodifiableCollection(this.startedTenants);
    }

    @Override
    public Tenant getTenantFromSession(HttpSession session) {
        String name = MultiTenantServletFilter.getTenantName(session);
        return this.datastore.get(name);
    }

    @Override
    public Tenant getTenantByName(String name) {
        return this.datastore.get(name);
    }

    @Override
    public boolean isSystemTenant() {
        return this.tenantReference.get() == MultiTenantContext.getSystemTenant();
    }
}

