/*
 * Decompiled with CFR 0.152.
 */
package webwork.multipart;

import java.io.Serializable;

public class ProgressMonitor
implements Serializable {
    private static final long serialVersionUID = 5344649008664921629L;
    private static final long MIN_SAMPLE_TIME = 150L;
    private static final int HISTORY_SIZE = 20;
    private String fileName;
    private int read;
    private long size;
    private boolean completed;
    private long startTime;
    private int[][] history = new int[20][2];
    private boolean historyFull = false;
    private int historyIndex = 0;
    private long lastHistoryTime;
    private long lastHistoryTotal;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.lastHistoryTime = this.startTime = System.currentTimeMillis();
    }

    public int getRead() {
        return this.read;
    }

    public void setRead(int read) {
        long now = System.currentTimeMillis();
        long timeSinceLastRead = now - this.lastHistoryTime;
        if (timeSinceLastRead > 150L) {
            long diff = this.read == 0 ? (long)read : (long)read - this.lastHistoryTotal;
            this.history[this.historyIndex][0] = (int)diff;
            this.history[this.historyIndex][1] = (int)timeSinceLastRead;
            ++this.historyIndex;
            if (this.historyIndex == 20) {
                this.historyFull = true;
                this.historyIndex = 0;
            }
            this.lastHistoryTime = now;
            this.lastHistoryTotal = read;
        }
        this.read = read;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getRemainingSeconds() {
        int bitrate = this.getBitRate();
        if (bitrate == 0) {
            return 0;
        }
        return (int)((this.size - (long)this.read) / (long)bitrate);
    }

    public int getBitRate() {
        if (this.completed || this.startTime == 0L) {
            return 0;
        }
        int totalBytes = 0;
        int totalTime = 0;
        int end = this.history.length;
        if (!this.historyFull) {
            end = this.historyIndex;
        }
        for (int i = 0; i < end; ++i) {
            int[] values = this.history[i];
            totalBytes += values[0];
            totalTime += values[1];
        }
        if (totalTime == 0) {
            return 0;
        }
        double timeInSeconds = (double)totalTime / 1000.0;
        return (int)((double)totalBytes / timeInSeconds);
    }

    public long getRemaining() {
        return this.size - (long)this.read;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }
}

