/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.CharCommonAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

class LongAccessor
extends CharCommonAccessor {
    OracleInputStream stream;
    int columnPosition = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    LongAccessor(OracleStatement oracleStatement, int n2, int n3, short s2, int n4) throws SQLException {
        this.init(oracleStatement, 8, 8, s2, false);
        this.columnPosition = n2;
        this.initForDataAccess(n4, n3, null);
    }

    LongAccessor(OracleStatement oracleStatement, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2) throws SQLException {
        this.init(oracleStatement, 8, 8, s2, false);
        this.columnPosition = n2;
        this.initForDescribe(8, n3, bl, n4, n5, n6, n7, n8, s2, null);
        int n9 = oracleStatement.maxFieldSize;
        if (n9 > 0 && (n3 == 0 || n9 < n3)) {
            n3 = n9;
        }
        this.initForDataAccess(0, n3, null);
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.isStream = true;
        this.isColumnNumberAware = true;
        this.internalTypeMaxLength = Integer.MAX_VALUE;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.charLength = 0;
        this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
    }

    OracleInputStream initForNewRow() throws SQLException {
        this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
        return this.stream;
    }

    void updateColumnNumber(int n2) {
        this.columnPosition = ++n2;
        if (this.stream != null) {
            this.stream.columnIndex = n2;
        }
    }

    byte[] getBytes(int n2) throws SQLException {
        return this.getBytesInternal(n2);
    }

    byte[] getBytesInternal(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray2 = new byte[1024];
            try {
                int n3;
                while ((n3 = this.stream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n3);
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    String getString(int n2) throws SQLException {
        String string = null;
        byte[] byArray = this.getBytes(n2);
        if (byArray != null) {
            int n3 = Math.min(byArray.length, this.internalTypeMaxLength);
            string = n3 == 0 ? "" : (this.formOfUse == 2 ? this.statement.connection.conversion.NCharBytesToString(byArray, n3) : this.statement.connection.conversion.CharBytesToString(byArray, n3));
        }
        return string;
    }

    InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 0);
        }
        return inputStream;
    }

    InputStream getUnicodeStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 1);
        }
        return inputStream;
    }

    Reader getCharacterStream(int n2) throws SQLException {
        Reader reader = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            reader = physicalConnection.conversion.ConvertCharacterStream(this.stream, 9, this.formOfUse);
        }
        return reader;
    }

    InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 6);
        }
        return inputStream;
    }

    public String toString() {
        return "LongAccessor@" + Integer.toHexString(this.hashCode()) + "{columnPosition = " + this.columnPosition + "}";
    }
}

