/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer.xml;

import java.util.Iterator;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.renderer.TableCellRenderer;
import net.sf.statcvs.reportmodel.Column;
import net.sf.statcvs.reportmodel.Table;
import org.jdom.Element;

public class XMLTableRenderer
implements TableCellRenderer {
    private final String tableElementName;
    private final String rowElementName;
    private String cellRendererResult;

    public XMLTableRenderer(String tableElementName, String rowElementName) {
        this.tableElementName = tableElementName;
        this.rowElementName = rowElementName;
    }

    public Element getRenderedTable(Table table) {
        Element result = new Element(this.tableElementName);
        result.setAttribute("summary", table.getSummary());
        for (int i = 0; i < table.getRowCount(); ++i) {
            Element row = new Element(this.rowElementName);
            Iterator it = table.getColumnIterator();
            int colCount = 1;
            while (it.hasNext()) {
                Column col = (Column)it.next();
                col.renderHead(this);
                String attributeName = XMLTableRenderer.convertToXMLName(this.cellRendererResult);
                if (attributeName == null) {
                    attributeName = "column" + colCount;
                }
                col.renderCell(i, this);
                row.setAttribute(attributeName, this.cellRendererResult);
                ++colCount;
            }
            result.addContent(row);
        }
        return result;
    }

    public static String convertToXMLName(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean previousWasDeleted = false;
        boolean previousWasLowerCase = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (result.length() == 0) {
                if (!Character.isLetter(c) && c != '_' && c != ':') continue;
                result.append(Character.toLowerCase(c));
                previousWasLowerCase = Character.isLowerCase(c);
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c != ':' && c != '.' && c != '-') {
                previousWasDeleted = true;
                continue;
            }
            if (previousWasDeleted) {
                result.append(Character.toUpperCase(c));
            } else if (!previousWasLowerCase) {
                result.append(Character.toLowerCase(c));
            } else {
                result.append(c);
            }
            previousWasDeleted = false;
            previousWasLowerCase = Character.isLowerCase(c);
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public void renderCell(String content) {
        this.cellRendererResult = content;
    }

    public void renderEmptyCell() {
        this.cellRendererResult = null;
    }

    public void renderIntegerCell(int value) {
        this.cellRendererResult = Integer.toString(value);
    }

    public void renderIntegerCell(int value, int total) {
        this.cellRendererResult = Integer.toString(value);
    }

    public void renderPercentageCell(double ratio) {
        this.cellRendererResult = this.getPercentage(ratio);
    }

    public void renderAuthorCell(Author author) {
        this.cellRendererResult = author.getName();
    }

    public void renderDirectoryCell(Directory directory) {
        this.cellRendererResult = directory.getPath();
    }

    public void renderFileCell(CvsFile file, boolean withIcon) {
        this.cellRendererResult = file.getFilenameWithPath();
    }

    private String getPercentage(double ratio) {
        if (Double.isNaN(ratio)) {
            return "-";
        }
        int percentTimes10 = (int)Math.round(ratio * 1000.0);
        double percent = (double)percentTimes10 / 10.0;
        return Double.toString(percent) + "%";
    }
}

