/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.renderer.Chart;
import net.sf.statcvs.reportmodel.TimeLine;
import net.sf.statcvs.reportmodel.TimePoint;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYStepRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class TimeLineChart
extends Chart {
    private static Logger logger = Logger.getLogger((String)"net.sf.statcvs.renderer.LOCChart");
    static /* synthetic */ Class class$org$jfree$data$time$Millisecond;

    public TimeLineChart(TimeLine timeLine, String fileName, int width, int height) {
        super(timeLine.getTitle(), fileName);
        TimeSeriesCollection collection = new TimeSeriesCollection();
        collection.addSeries(this.createTimeSeries(timeLine));
        logger.debug((Object)("creating time line chart for " + timeLine.getTitle() + " / " + timeLine.getTitle()));
        String range = timeLine.getRangeLabel();
        String domain = Messages.getString("DOMAIN_TIME");
        TimeSeriesCollection data = collection;
        this.setChart(ChartFactory.createTimeSeriesChart((String)ConfigurationOptions.getProjectName(), (String)domain, (String)range, (XYDataset)data, (boolean)false, (boolean)false, (boolean)false));
        XYPlot plot = (XYPlot)this.getChart().getPlot();
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.blue);
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setVerticalTickLabels(true);
        plot.setRenderer((XYItemRenderer)new XYStepRenderer());
        this.createChart();
        this.saveChart(width, height);
    }

    private TimeSeries createTimeSeries(TimeLine timeLine) {
        TimeSeries result = new TimeSeries("!??!SERIES_LABEL!??!", class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = TimeLineChart.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
        Iterator it = timeLine.getDataPoints().iterator();
        while (it.hasNext()) {
            TimePoint timePoint = (TimePoint)it.next();
            result.add((RegularTimePeriod)new Millisecond(timePoint.getDate()), (double)timePoint.getValue());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

