/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.IOException;
import java.io.Reader;
import net.sf.statcvs.input.CvsFileBlockParser;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.EmptyRepositoryException;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.util.LookaheadReader;
import org.apache.log4j.Logger;

public class CvsLogfileParser {
    public static String VERBOSE_SERVER_OUTPUT = "cvs server: ";
    private static Logger logger = Logger.getLogger((String)(class$net$sf$statcvs$input$CvsLogfileParser == null ? (class$net$sf$statcvs$input$CvsLogfileParser = CvsLogfileParser.class$("net.sf.statcvs.input.CvsLogfileParser")) : class$net$sf$statcvs$input$CvsLogfileParser).getName());
    private LookaheadReader logReader;
    private CvsLogBuilder builder;
    static /* synthetic */ Class class$net$sf$statcvs$input$CvsLogfileParser;

    public CvsLogfileParser(Reader logReader, CvsLogBuilder builder) {
        this.logReader = new LookaheadReader(logReader);
        this.builder = builder;
    }

    public void parse() throws LogSyntaxException, IOException, EmptyRepositoryException {
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"starting to parse...");
        this.eatNonCheckedInFileLines();
        if (this.logReader.isAfterEnd()) {
            throw new LogSyntaxException("empty logfile!");
        }
        if (!this.logReader.isAfterEnd() && !"".equals(this.logReader.getCurrentLine())) {
            throw new LogSyntaxException("expected '?' or empty line at line " + this.logReader.getLineNumber() + ", but found '" + this.logReader.getCurrentLine() + "'");
        }
        this.eatEmptyLines();
        boolean isFirstFile = true;
        do {
            CvsFileBlockParser parser = new CvsFileBlockParser(this.logReader, this.builder, isFirstFile);
            parser.parse();
            isFirstFile = false;
            this.eatEmptyLines();
        } while (!this.logReader.isAfterEnd());
        logger.debug((Object)("parsing finished in " + (System.currentTimeMillis() - startTime) + " ms."));
    }

    private void eatNonCheckedInFileLines() throws LogSyntaxException, IOException {
        while (!this.logReader.isAfterEnd() && (this.logReader.getCurrentLine().startsWith("? ") || this.logReader.getCurrentLine().startsWith(VERBOSE_SERVER_OUTPUT))) {
            this.logReader.getNextLine();
        }
    }

    private void eatEmptyLines() throws IOException {
        while (!this.logReader.isAfterEnd() && this.logReader.getCurrentLine().equals("")) {
            this.logReader.getNextLine();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

