/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.ant;

import java.io.IOException;
import net.sf.statcvs.Main;
import net.sf.statcvs.input.EmptyRepositoryException;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.ConfigurationOptions;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class StatCvsTask
extends Task {
    private String title;
    private String logFile;
    private String pDir;
    private String outDir;
    private String cssFile;
    private String notesFile;
    private String viewcvs;
    private String cvsweb;
    private String chora;
    private String include = null;
    private String exclude = null;

    public void execute() throws BuildException {
        try {
            this.initProperties();
            Main.generateDefaultHTMLSuite();
        }
        catch (ConfigurationException e) {
            throw new BuildException(e.getMessage());
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage());
        }
        catch (LogSyntaxException e) {
            throw new BuildException(e.getMessage());
        }
        catch (EmptyRepositoryException e) {
            throw new BuildException("No revisions in the log!");
        }
    }

    private void initProperties() throws ConfigurationException {
        ConfigurationOptions.setLogFileName(this.logFile);
        ConfigurationOptions.setCheckedOutDirectory(this.pDir);
        if (this.title != null) {
            ConfigurationOptions.setProjectName(this.title);
        }
        if (this.outDir != null) {
            ConfigurationOptions.setOutputDir(this.outDir);
        }
        if (this.cssFile != null) {
            ConfigurationOptions.setCssFile(this.cssFile);
        }
        if (this.notesFile != null) {
            ConfigurationOptions.setNotesFile(this.notesFile);
        }
        if (this.viewcvs != null) {
            ConfigurationOptions.setViewCvsURL(this.viewcvs);
        }
        if (this.cvsweb != null) {
            ConfigurationOptions.setCvswebURL(this.cvsweb);
        }
        if (this.chora != null) {
            ConfigurationOptions.setChoraURL(this.chora);
        }
        if (this.include != null) {
            ConfigurationOptions.setIncludePattern(this.include);
        }
        if (this.exclude != null) {
            ConfigurationOptions.setExcludePattern(this.exclude);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCvsLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setProjectDirectory(String modDir) {
        this.pDir = modDir;
    }

    public void setOutputDirectory(String outDir) {
        this.outDir = outDir;
    }

    public void setCssFile(String cssFile) {
        this.cssFile = cssFile;
    }

    public void setNotesFile(String notesFile) {
        this.notesFile = notesFile;
    }

    public void setViewcvsURL(String viewcvs) {
        this.viewcvs = viewcvs;
    }

    public void setCvswebURL(String cvsweb) {
        this.cvsweb = cvsweb;
    }

    public void setChoraURL(String chora) {
        this.chora = chora;
    }

    public void setIncludeFiles(String include) {
        this.include = include;
    }

    public void setExcludeFiles(String exclude) {
        this.exclude = exclude;
    }
}

