/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.linkrenderer;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.ViewLinkFormat;
import com.atlassian.jira.plugin.ext.subversion.linkrenderer.SubversionLinkRenderer;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class LinkFormatRenderer
implements SubversionLinkRenderer {
    private static Logger log = Logger.getLogger(LinkFormatRenderer.class);
    private String pathLinkFormat;
    private String fileReplacedFormat;
    private String fileAddedFormat;
    private String fileModifiedFormat;
    private String fileDeletedFormat;
    private String changesetFormat;

    public LinkFormatRenderer(SubversionManager subversionManager) {
        ViewLinkFormat linkFormat = subversionManager.getViewLinkFormat();
        if (linkFormat != null) {
            if (linkFormat.getChangesetFormat() != null && linkFormat.getChangesetFormat().trim().length() != 0) {
                this.changesetFormat = linkFormat.getChangesetFormat();
            }
            if (linkFormat.getFileAddedFormat() != null && linkFormat.getFileAddedFormat().trim().length() != 0) {
                this.fileAddedFormat = linkFormat.getFileAddedFormat();
            }
            if (linkFormat.getFileModifiedFormat() != null && linkFormat.getFileModifiedFormat().trim().length() != 0) {
                this.fileModifiedFormat = linkFormat.getFileModifiedFormat();
            }
            if (linkFormat.getFileReplacedFormat() != null && linkFormat.getFileReplacedFormat().trim().length() != 0) {
                this.fileReplacedFormat = linkFormat.getFileReplacedFormat();
            }
            if (linkFormat.getFileDeletedFormat() != null && linkFormat.getFileDeletedFormat().trim().length() != 0) {
                this.fileDeletedFormat = linkFormat.getFileDeletedFormat();
            }
            if (linkFormat.getViewFormat() != null && linkFormat.getViewFormat().trim().length() != 0) {
                this.pathLinkFormat = linkFormat.getViewFormat();
            }
        } else {
            log.warn((Object)"viewLinkFormat is null");
        }
    }

    public String getCopySrcLink(SVNLogEntry revision, SVNLogEntryPath logEntryPath) {
        long revisionNumber = revision.getRevision();
        return this.linkPath(this.pathLinkFormat, logEntryPath.getCopyPath(), revisionNumber);
    }

    public String getRevisionLink(SVNLogEntry revision) {
        return this.getRevisionLink(revision.getRevision());
    }

    public String getChangePathLink(SVNLogEntry revision, SVNLogEntryPath logEntryPath) {
        char changeType = logEntryPath.getType();
        String path = logEntryPath.getPath();
        long revisionNumber = revision.getRevision();
        if (changeType == 'M') {
            return this.linkPath(this.fileModifiedFormat, path, revisionNumber);
        }
        if (changeType == 'A') {
            return this.linkPath(this.fileAddedFormat, path, revisionNumber);
        }
        if (changeType == 'R') {
            return this.linkPath(this.fileReplacedFormat, path, revisionNumber);
        }
        if (changeType == 'D') {
            return this.linkPath(this.fileDeletedFormat, path, revisionNumber);
        }
        return this.linkPath(this.fileReplacedFormat, path, revisionNumber);
    }

    protected String getRevisionLink(long revisionNumber) {
        if (this.changesetFormat != null) {
            try {
                String href = StringUtils.replaceAll((String)this.changesetFormat, (String)"${rev}", (String)("" + revisionNumber));
                return "<a href=\"" + href + "\">#" + revisionNumber + "</a>";
            }
            catch (Exception ex) {
                log.error((Object)("format error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return "#" + revisionNumber;
    }

    private String linkPath(String format, String path, long revisionNumber) {
        if (path != null && path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        if (format != null) {
            try {
                String href = format;
                if (path != null) {
                    href = StringUtils.replaceAll((String)href, (String)"${path}", (String)path);
                }
                href = StringUtils.replaceAll((String)href, (String)"${rev}", (String)("" + revisionNumber));
                href = StringUtils.replaceAll((String)href, (String)"${rev-1}", (String)("" + (revisionNumber - 1L)));
                return "<a href=\"" + href + "\">" + path + "</a>";
            }
            catch (Exception ex) {
                log.error((Object)("format error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return path;
    }
}

