/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.issuetabpanels.changes;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.issuetabpanels.changes.SubversionRevisionAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.EasyList;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.action.issue.ViewIssue;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.user.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNLogEntry;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.factory.ActionFactory;

public class SubversionRevisionsTabPanel
extends AbstractIssueTabPanel {
    private static Logger log = Logger.getLogger(SubversionRevisionsTabPanel.class);
    private final MultipleSubversionRepositoryManager multipleSubversionRepositoryManager;
    private final PermissionManager permissionManager;
    private final WebResourceManager webResourceManager;
    private final VelocityRequestContextFactory requestContextFactory;
    public static final int NUMBER_OF_REVISIONS = 100;

    public SubversionRevisionsTabPanel(MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, PermissionManager permissionManager, WebResourceManager webResourceManager, VelocityRequestContextFactory requestContextFactory) {
        this.multipleSubversionRepositoryManager = multipleSubversionRepositoryManager;
        this.permissionManager = permissionManager;
        this.webResourceManager = webResourceManager;
        this.requestContextFactory = requestContextFactory;
    }

    public List getActions(Issue issue, User remoteUser) {
        this.webResourceManager.requireResource("com.atlassian.jira.plugin.ext.subversion:subversion-resource-js");
        try {
            boolean sortAscending = this.isSortingActionsInAscendingOrder();
            int pageSize = this.getPageSizeRequestParameter();
            Map<Long, List<SVNLogEntry>> logEntries = this.multipleSubversionRepositoryManager.getRevisionIndexer().getLogEntriesByRepository(issue, this.getPageRequestParameter() * pageSize, pageSize + 1, sortAscending);
            if (logEntries == null) {
                GenericMessageAction action = new GenericMessageAction(this.getText("no.index.error.message"));
                return EasyList.build((Object)action);
            }
            if (logEntries.isEmpty()) {
                GenericMessageAction action = new GenericMessageAction(this.getText("no.log.entries.message"));
                return EasyList.build((Object)action);
            }
            List<SubversionRevisionAction> actions = new ArrayList<SubversionRevisionAction>();
            for (Map.Entry<Long, List<SVNLogEntry>> entry : logEntries.entrySet()) {
                for (SVNLogEntry logEntry : entry.getValue()) {
                    actions.add(this.createSubversionRevisionAction(entry.getKey(), logEntry));
                }
            }
            if (!sortAscending) {
                Collections.reverse(actions);
            }
            if (!actions.isEmpty() && actions.size() > pageSize) {
                actions = sortAscending ? actions.subList(0, pageSize) : actions.subList(1, actions.size());
                int lastActionIndex = sortAscending ? actions.size() - 1 : 0;
                SubversionRevisionAction lastAction = (SubversionRevisionAction)((Object)actions.get(lastActionIndex));
                actions.set(lastActionIndex, this.createLastSubversionRevisionActionInPage(lastAction.getRepoId(), lastAction.getRevision()));
            }
            return actions;
        }
        catch (IndexException ie) {
            log.error((Object)"There's a problem with the Subversion index.", (Throwable)ie);
        }
        catch (IOException ioe) {
            log.error((Object)"Unable to read Subversion index.", (Throwable)ioe);
        }
        return Collections.emptyList();
    }

    boolean isSortingActionsInAscendingOrder() {
        try {
            Action viewIssueAction = ActionFactory.getActionFactory().getActionImpl(ViewIssue.class.getName());
            return !StringUtils.equalsIgnoreCase((String)this.getActionSortOrder(viewIssueAction), (String)"desc");
        }
        catch (Exception e) {
            log.error((Object)"Unable to figure out how actions are sorted. I'm going to default to ascending", (Throwable)e);
            return true;
        }
    }

    private String getActionSortOrder(Action viewIssueAction) {
        String defaultOrder = ((ViewIssue)viewIssueAction).getApplicationProperties().getDefaultString("jira.issue.actions.order");
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        String actionOrder = requestContext.getRequestParameter("actionOrder");
        VelocityRequestSession session = requestContext.getSession();
        if (StringUtils.isNotBlank((String)actionOrder)) {
            if (!actionOrder.equals(defaultOrder)) {
                session.setAttribute("jira.issue.action.order", (Object)actionOrder);
                return defaultOrder;
            }
            session.removeAttribute("jira.issue.action.order");
            return defaultOrder;
        }
        actionOrder = (String)session.getAttribute("jira.issue.action.order");
        if (StringUtils.isNotBlank((String)actionOrder)) {
            return actionOrder;
        }
        return defaultOrder;
    }

    private int getPageRequestParameter() {
        HttpServletRequest req = ActionContext.getRequest();
        if (null != req) {
            String pageIndexString = req.getParameter("pageIndex");
            return StringUtils.isBlank((String)pageIndexString) ? 0 : Integer.parseInt(pageIndexString);
        }
        return 0;
    }

    private int getPageSizeRequestParameter() {
        HttpServletRequest req = ActionContext.getRequest();
        if (null != req) {
            String pageIndexString = req.getParameter("pageSize");
            return StringUtils.isBlank((String)pageIndexString) ? 100 : Integer.parseInt(pageIndexString);
        }
        return 100;
    }

    SubversionRevisionAction createSubversionRevisionAction(long repoId, SVNLogEntry logEntry) {
        return new SubversionRevisionAction(logEntry, this.multipleSubversionRepositoryManager, this.descriptor, repoId);
    }

    SubversionRevisionAction createLastSubversionRevisionActionInPage(long repoId, SVNLogEntry logEntry) {
        return new LastSubversionRevisionActionInPage(logEntry, this.multipleSubversionRepositoryManager, this.descriptor, repoId);
    }

    String getText(String key) {
        return this.descriptor.getI18nBean().getText(key);
    }

    public boolean showPanel(Issue issue, User remoteUser) {
        return this.multipleSubversionRepositoryManager.isIndexingRevisions() && this.permissionManager.hasPermission(29, issue, remoteUser);
    }

    private class LastSubversionRevisionActionInPage
    extends SubversionRevisionAction {
        public LastSubversionRevisionActionInPage(SVNLogEntry logEntry, MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, IssueTabPanelModuleDescriptor descriptor, long repoId) {
            super(logEntry, multipleSubversionRepositoryManager, descriptor, repoId);
        }
    }
}

