/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManagerImpl;
import com.atlassian.jira.plugin.ext.subversion.SubversionProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnPropertiesLoader {
    private static Logger log = Logger.getLogger(SvnPropertiesLoader.class);
    public static final String PROPERTIES_FILE_NAME = "subversion-jira-plugin.properties";

    public static List<SubversionProperties> getSVNProperties() throws InfrastructureException {
        SubversionProperties prop;
        Properties allProps = System.getProperties();
        try {
            allProps.load(ClassLoaderUtils.getResourceAsStream((String)PROPERTIES_FILE_NAME, MultipleSubversionRepositoryManagerImpl.class));
        }
        catch (IOException e) {
            throw new InfrastructureException("Problem loading subversion-jira-plugin.properties.", (Throwable)e);
        }
        ArrayList<SubversionProperties> propertyList = new ArrayList<SubversionProperties>();
        SubversionProperties defaultProps = SvnPropertiesLoader.getSubversionProperty(-1, allProps);
        if (defaultProps == null) {
            log.error((Object)"Could not load properties from subversion-jira-plugin.properties");
            throw new InfrastructureException("Could not load properties from subversion-jira-plugin.properties");
        }
        propertyList.add(defaultProps);
        int i = 1;
        do {
            prop = SvnPropertiesLoader.getSubversionProperty(i, allProps);
            ++i;
            if (prop == null) continue;
            prop.fillPropertiesFromOther(defaultProps);
            propertyList.add(prop);
        } while (prop != null);
        return propertyList;
    }

    protected static SubversionProperties getSubversionProperty(int index, Properties props) {
        String indexStr = "." + Integer.toString(index);
        if (index == -1) {
            indexStr = "";
        }
        if (props.containsKey("svn.root" + indexStr)) {
            String svnRootStr = props.getProperty("svn.root" + indexStr);
            String displayName = props.getProperty("svn.display.name" + indexStr);
            String changesetFormat = props.getProperty("linkformat.changeset" + indexStr);
            String fileAddedFormat = props.getProperty("linkformat.file.added" + indexStr);
            String fileModifiedFormat = props.getProperty("linkformat.file.modified" + indexStr);
            String fileReplacedFormat = props.getProperty("linkformat.file.replaced" + indexStr);
            String fileDeletedFormat = props.getProperty("linkformat.file.deleted" + indexStr);
            String username = props.getProperty("svn.username" + indexStr);
            String password = props.getProperty("svn.password" + indexStr);
            String privateKeyFile = props.getProperty("svn.privatekeyfile" + indexStr);
            Boolean revisionIndexing = null;
            if (props.containsKey("revision.indexing" + indexStr)) {
                revisionIndexing = "true".equalsIgnoreCase(props.getProperty("revision.indexing" + indexStr));
            }
            Integer revisionCacheSize = null;
            if (props.containsKey("revision.cache.size" + indexStr)) {
                revisionCacheSize = new Integer(props.getProperty("revision.cache.size" + indexStr));
            }
            return new SubversionProperties().setRoot(svnRootStr).setDisplayName(displayName).setChangeSetFormat(changesetFormat).setFileAddedFormat(fileAddedFormat).setFileModifiedFormat(fileModifiedFormat).setFileReplacedFormat(fileReplacedFormat).setFileDeletedFormat(fileDeletedFormat).setUsername(username).setPassword(password).setPrivateKeyFile(privateKeyFile).setRevisionIndexing(revisionIndexing).setRevisioningCacheSize(revisionCacheSize);
        }
        log.info((Object)("No svn.root" + indexStr + " specified in " + PROPERTIES_FILE_NAME));
        return null;
    }
}

