/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.plugin.ext.subversion.ISVNAuthenticationManagerDelegator;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.SvnProperties;
import com.atlassian.jira.plugin.ext.subversion.ViewLinkFormat;
import com.atlassian.jira.plugin.ext.subversion.linkrenderer.LinkFormatRenderer;
import com.atlassian.jira.plugin.ext.subversion.linkrenderer.NullLinkRenderer;
import com.atlassian.jira.plugin.ext.subversion.linkrenderer.SubversionLinkRenderer;
import com.atlassian.jira.util.JiraKeyUtils;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SubversionManagerImpl
implements SubversionManager {
    private static Logger log = Logger.getLogger(SubversionManagerImpl.class);
    private SubversionLinkRenderer linkRenderer;
    private Map logEntryCache;
    private SVNRepository repository;
    private boolean active;
    private String inactiveMessage;
    private long id;
    private PropertySet properties;
    private ViewLinkFormat viewLinkFormat = null;
    private boolean isViewLinkSet = false;

    public SubversionManagerImpl(long id, PropertySet props) {
        this.id = id;
        this.properties = props;
        this.setup();
    }

    public synchronized void update(SvnProperties props) {
        this.deactivate(null);
        SvnProperties.Util.fillPropertySet(props, this.properties);
        this.isViewLinkSet = false;
        this.setup();
    }

    protected void setup() {
        this.linkRenderer = null;
        this.linkRenderer = this.getViewLinkFormat() != null ? new LinkFormatRenderer(this) : new NullLinkRenderer();
        if (this.isRevisionIndexing()) {
            int cacheSize = 10000;
            if (this.getRevisioningCacheSize() > 0) {
                cacheSize = this.getRevisioningCacheSize();
            }
            this.logEntryCache = new LRUMap(cacheSize);
        } else {
            this.logEntryCache = new LRUMap();
        }
        this.activate();
    }

    public synchronized Collection getLogEntries(long revision) {
        long latestRevision;
        final ArrayList logEntries = new ArrayList();
        if (!this.isActive()) {
            return logEntries;
        }
        try {
            latestRevision = this.repository.getLatestRevision();
        }
        catch (SVNException e) {
            log.error((Object)"Error getting the latest revision from the repository.", (Throwable)e);
            this.deactivate(e.getMessage());
            return logEntries;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Latest revision in repository=" + this.getRoot() + "  is : " + latestRevision));
        }
        if (latestRevision > 0L && latestRevision <= revision) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Have all the commits for repository=" + this.getRoot() + " - doing nothing."));
            }
            return logEntries;
        }
        long retrieveStart = revision + 1L;
        if (retrieveStart < 0L) {
            retrieveStart = 0L;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving revisions to index (between " + retrieveStart + " and " + latestRevision + ") for repository=" + this.getRoot()));
        }
        try {
            this.repository.log(new String[]{""}, retrieveStart, latestRevision, true, true, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Retrieved #" + logEntry.getRevision() + " : " + logEntry.getMessage()));
                    }
                    if (TextUtils.stringSet((String)logEntry.getMessage()) && JiraKeyUtils.isKeyInString((String)StringUtils.upperCase((String)logEntry.getMessage()))) {
                        logEntries.add(logEntry);
                    }
                }
            });
        }
        catch (SVNException e) {
            log.error((Object)"Error retrieving changes from the repository.", (Throwable)e);
            this.deactivate(e.getMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved " + logEntries.size() + " relevant revisions to index (between " + retrieveStart + " and " + latestRevision + ") from repository=" + this.getRoot()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("log entries size = " + logEntries.size() + " for " + this.getRoot()));
        }
        return logEntries;
    }

    public synchronized SVNLogEntry getLogEntry(long revision) {
        if (!this.isActive()) {
            throw new IllegalStateException("The connection to the repository is not active");
        }
        final SVNLogEntry[] logEntry = new SVNLogEntry[]{(SVNLogEntry)this.logEntryCache.get(new Long(revision))};
        if (logEntry[0] == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No cache - retrieving log message for revision: " + revision));
                }
                this.repository.log(new String[]{""}, revision, revision, true, true, new ISVNLogEntryHandler(){

                    public void handleLogEntry(SVNLogEntry entry) {
                        logEntry[0] = entry;
                        SubversionManagerImpl.this.ensureCached(entry);
                    }
                });
            }
            catch (SVNException e) {
                log.error((Object)("Error retrieving logs: " + (Object)((Object)e)), (Throwable)e);
                this.deactivate(e.getMessage());
                throw new InfrastructureException((Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Found cached log message for revision: " + revision));
        }
        return logEntry[0];
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCached(SVNLogEntry logEntry) {
        Map map = this.logEntryCache;
        synchronized (map) {
            this.logEntryCache.put(new Long(logEntry.getRevision()), logEntry);
        }
    }

    public PropertySet getProperties() {
        return this.properties;
    }

    public String getDisplayName() {
        return !this.properties.exists("svn.display.name") ? this.getRoot() : this.properties.getString("svn.display.name");
    }

    public String getRoot() {
        return this.properties.getString("svn.root");
    }

    public String getUsername() {
        return this.properties.getString("svn.username");
    }

    public String getPassword() {
        try {
            return SubversionManagerImpl.decryptPassword(this.properties.getString("svn.password"));
        }
        catch (IOException e) {
            log.error((Object)"Couldn't decrypt the password. Reseting it to null.", (Throwable)e);
            return null;
        }
    }

    public boolean isRevisionIndexing() {
        return this.properties.getBoolean("revision.indexing");
    }

    public int getRevisioningCacheSize() {
        return this.properties.getInt("revision.cache.size");
    }

    public String getPrivateKeyFile() {
        return this.properties.getString("svn.privatekeyfile");
    }

    public boolean isActive() {
        return this.active;
    }

    public String getInactiveMessage() {
        return this.inactiveMessage;
    }

    public void activate() {
        try {
            SVNURL url = this.parseSvnUrl();
            this.repository = this.createRepository(url);
            Object authManager = null != this.getPrivateKeyFile() ? new BasicAuthenticationManager(this.getUsername(), new File(this.getPrivateKeyFile()), this.getPassword(), 22) : SVNWCUtil.createDefaultAuthenticationManager((String)this.getUsername(), (String)this.getPassword());
            this.repository.setAuthenticationManager((ISVNAuthenticationManager)new ISVNAuthenticationManagerDelegator((ISVNAuthenticationManager)authManager));
            this.repository.testConnection();
            this.active = true;
        }
        catch (SVNException e) {
            log.error((Object)("Connection to Subversion repository " + this.getRoot() + " failed: " + (Object)((Object)e)), (Throwable)e);
            this.active = false;
            this.inactiveMessage = e.getMessage();
        }
    }

    SVNURL parseSvnUrl() throws SVNException {
        return SVNURL.parseURIEncoded((String)this.getRoot());
    }

    SVNRepository createRepository(SVNURL url) throws SVNException {
        return SVNRepositoryFactory.create((SVNURL)url);
    }

    private void deactivate(String message) {
        if (this.repository != null) {
            this.repository.closeSession();
            this.repository = null;
        }
        this.active = false;
        this.inactiveMessage = message;
    }

    public ViewLinkFormat getViewLinkFormat() {
        if (!this.isViewLinkSet) {
            String type = this.properties.getString("linkformat.type");
            String linkPathFormat = this.properties.getString("linkformat.copyfrom");
            String changesetFormat = this.properties.getString("linkformat.changeset");
            String fileAddedFormat = this.properties.getString("linkformat.file.added");
            String fileModifiedFormat = this.properties.getString("linkformat.file.modified");
            String fileReplacedFormat = this.properties.getString("linkformat.file.replaced");
            String fileDeletedFormat = this.properties.getString("linkformat.file.deleted");
            this.viewLinkFormat = linkPathFormat != null || changesetFormat != null || fileAddedFormat != null || fileModifiedFormat != null || fileReplacedFormat != null || fileDeletedFormat != null ? new ViewLinkFormat(type, changesetFormat, fileAddedFormat, fileModifiedFormat, fileReplacedFormat, fileDeletedFormat, linkPathFormat) : null;
            this.isViewLinkSet = true;
        }
        return this.viewLinkFormat;
    }

    public SubversionLinkRenderer getLinkRenderer() {
        return this.linkRenderer;
    }

    protected static String decryptPassword(String encrypted) throws IOException {
        if (encrypted == null) {
            return null;
        }
        byte[] result = Base64.decodeBase64((String)encrypted);
        return new String(result, 0, result.length);
    }

    protected static String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        return Base64.encodeBase64String((byte[])password.getBytes());
    }
}

