/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.util.Arrays;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

class HTTPNegotiateAuthentication
extends HTTPAuthentication {
    private static volatile Boolean ourIsNegotiateSupported;
    private GSSManager myGSSManager = GSSManager.getInstance();
    private GSSContext myGSSContext;
    private Oid mySpnegoOid;
    private byte[] myToken;
    private int myTokenLength;

    HTTPNegotiateAuthentication() {
    }

    public static synchronized boolean isSupported() {
        if (ourIsNegotiateSupported == null) {
            try {
                Oid spnegoOid = new Oid("1.3.6.1.5.5.2");
                ourIsNegotiateSupported = Arrays.asList(GSSManager.getInstance().getMechs()).contains(spnegoOid);
            }
            catch (GSSException gsse) {
                ourIsNegotiateSupported = Boolean.FALSE;
            }
        }
        return ourIsNegotiateSupported;
    }

    public String getAuthenticationScheme() {
        return "Negotiate";
    }

    private String getServerPrincipalName() {
        return "HTTP@" + this.getChallengeParameter("host");
    }

    public void respondTo(String challenge) {
        if (challenge == null) {
            this.myToken = new byte[0];
            this.myTokenLength = 0;
        } else {
            this.myToken = new byte[(challenge.length() * 3 + 3) / 4];
            this.myTokenLength = SVNBase64.base64ToByteArray(new StringBuffer(challenge), this.myToken);
        }
    }

    private void initializeContext() throws GSSException {
        if (this.mySpnegoOid == null) {
            this.mySpnegoOid = new Oid("1.3.6.1.5.5.2");
        }
        GSSName serverName = this.myGSSManager.createName(this.getServerPrincipalName(), GSSName.NT_HOSTBASED_SERVICE);
        this.myGSSContext = this.myGSSManager.createContext(serverName, this.mySpnegoOid, null, 0);
    }

    public String authenticate() throws SVNException {
        byte[] outtoken;
        if (!this.isStarted()) {
            try {
                this.initializeContext();
            }
            catch (GSSException gsse) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Negotiate authentication failed: ''{0}''", gsse.getMajorString());
                SVNErrorManager.error(err, SVNLogType.NETWORK);
                return null;
            }
        }
        try {
            outtoken = this.myGSSContext.initSecContext(this.myToken, 0, this.myTokenLength);
        }
        catch (GSSException gsse) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Negotiate authentication failed: ''{0}''", gsse.getMajorString());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
            return null;
        }
        if (this.myToken != null) {
            return "Negotiate " + SVNBase64.byteArrayToBase64(outtoken);
        }
        return null;
    }

    public boolean isStarted() {
        return this.myGSSContext != null;
    }
}

