/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.revisions.DefaultLuceneIndexAccessor;
import com.atlassian.jira.plugin.ext.subversion.revisions.LuceneIndexAccessor;
import com.atlassian.jira.plugin.ext.subversion.revisions.PermittedIssuesRevisionFilter;
import com.atlassian.jira.plugin.ext.subversion.revisions.ProjectRevisionFilter;
import com.atlassian.jira.plugin.ext.subversion.revisions.RevisionIndexService;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.util.JiraKeyUtils;
import com.opensymphony.user.User;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionIndexer {
    private static Logger log = Logger.getLogger(RevisionIndexer.class);
    private static final Long NOT_INDEXED = -1L;
    static final String REVISIONS_INDEX_DIRECTORY = "atlassian-subversion-revisions";
    public static final String FIELD_REVISIONNUMBER = "revision";
    public static final Term START_REVISION = new Term("revision", "");
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_AUTHOR = "author";
    public static final String FIELD_DATE = "date";
    public static final String FIELD_ISSUEKEY = "key";
    public static final String FIELD_PROJECTKEY = "project";
    public static final String FIELD_REPOSITORY = "repository";
    public static final StandardAnalyzer ANALYZER = new StandardAnalyzer();
    public static final int MAX_REVISIONS = 100;
    private final MultipleSubversionRepositoryManager multipleSubversionRepositoryManager;
    private final VersionManager versionManager;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final ServiceManager serviceManager;
    private final IndexPathManager indexPathManager;
    private Hashtable<Long, Long> latestIndexedRevisionTbl;
    private LuceneIndexAccessor indexAccessor;

    public RevisionIndexer(MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, VersionManager versionManager, IssueManager issueManager, PermissionManager permissionManager, ChangeHistoryManager changeHistoryManager, ServiceManager serviceManager, IndexPathManager indexPathManager) {
        this(multipleSubversionRepositoryManager, versionManager, issueManager, permissionManager, changeHistoryManager, serviceManager, new DefaultLuceneIndexAccessor(), indexPathManager);
    }

    RevisionIndexer(MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, VersionManager versionManager, IssueManager issueManager, PermissionManager permissionManager, ChangeHistoryManager changeHistoryManager, ServiceManager serviceManager, LuceneIndexAccessor accessor, IndexPathManager indexPathManager) {
        this.multipleSubversionRepositoryManager = multipleSubversionRepositoryManager;
        this.versionManager = versionManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.changeHistoryManager = changeHistoryManager;
        this.indexAccessor = accessor;
        this.serviceManager = serviceManager;
        this.indexPathManager = indexPathManager;
        this.initializeLatestIndexedRevisionCache();
    }

    public void start() {
        try {
            this.createIndexIfNeeded();
            RevisionIndexService.install(this.serviceManager);
        }
        catch (Exception e) {
            log.error((Object)"Error installing the revision index service.", (Throwable)e);
            throw new InfrastructureException("Error installing the revision index service.", (Throwable)e);
        }
    }

    private boolean createIndexIfNeeded() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RevisionIndexer.createIndexIfNeeded()");
        }
        boolean indexExists = this.indexDirectoryExists();
        if (this.getIndexPath() != null && !indexExists) {
            try {
                this.indexAccessor.getIndexWriter(this.getIndexPath(), true, (Analyzer)ANALYZER).close();
                this.initializeLatestIndexedRevisionCache();
                return true;
            }
            catch (IndexException e) {
                log.error((Object)"There's a problem initializing the index.", (Throwable)e);
                return false;
            }
            catch (IOException ioe) {
                log.error((Object)"There's a performing IO on the index.", (Throwable)ioe);
                return false;
            }
        }
        return indexExists;
    }

    private void initializeLatestIndexedRevisionCache() {
        Collection<SubversionManager> repositories = this.multipleSubversionRepositoryManager.getRepositoryList();
        this.latestIndexedRevisionTbl = new Hashtable();
        for (SubversionManager currentRepo : repositories) {
            this.initializeLatestIndexedRevisionCache(currentRepo);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of repositories: " + repositories.size()));
        }
    }

    private void initializeLatestIndexedRevisionCache(SubversionManager subversionManager) {
        this.latestIndexedRevisionTbl.put(subversionManager.getId(), NOT_INDEXED);
    }

    private boolean indexDirectoryExists() {
        try {
            File file = new File(this.getIndexPath());
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getIndexPath() {
        String indexPath = null;
        String rootIndexPath = this.indexPathManager.getPluginIndexRootPath();
        if (rootIndexPath != null) {
            indexPath = rootIndexPath + System.getProperty("file.separator") + REVISIONS_INDEX_DIRECTORY;
        } else {
            log.warn((Object)"At the moment the root index path of jira is not set, so we can not form an index path for the subversion plugin.");
        }
        return indexPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex() throws IndexException, IOException {
        if (this.createIndexIfNeeded()) {
            Collection<SubversionManager> repositories = this.multipleSubversionRepositoryManager.getRepositoryList();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of repositories: " + repositories.size()));
            }
            for (SubversionManager subversionManager : repositories) {
                try {
                    if (!subversionManager.isActive()) {
                        subversionManager.activate();
                        if (!subversionManager.isActive()) continue;
                    }
                    long repoId = subversionManager.getId();
                    long latestIndexedRevision = -1L;
                    if (this.getLatestIndexedRevision(repoId) == null) {
                        log.warn((Object)("Did not update index because null value in hash table for " + repoId));
                        continue;
                    }
                    latestIndexedRevision = this.getLatestIndexedRevision(repoId);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Updating revision index for repository=" + repoId));
                    }
                    if (latestIndexedRevision < 0L) {
                        latestIndexedRevision = this.updateLastRevisionIndexed(repoId);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Latest indexed revision for repository=" + repoId + " is : " + latestIndexedRevision));
                    }
                    Collection logEntries = subversionManager.getLogEntries(latestIndexedRevision);
                    IndexWriter writer = this.indexAccessor.getIndexWriter(this.getIndexPath(), false, (Analyzer)ANALYZER);
                    try {
                        IndexReader reader = this.indexAccessor.getIndexReader(this.getIndexPath());
                        try {
                            for (SVNLogEntry logEntry : logEntries) {
                                if (!TextUtils.stringSet((String)logEntry.getMessage()) || !this.isKeyInString(logEntry) || this.hasDocument(repoId, logEntry.getRevision(), reader)) continue;
                                Document doc = this.getDocument(repoId, logEntry);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Indexing repository=" + repoId + ", revision: " + logEntry.getRevision()));
                                }
                                writer.addDocument(doc);
                                if (logEntry.getRevision() <= latestIndexedRevision) continue;
                                latestIndexedRevision = logEntry.getRevision();
                                this.latestIndexedRevisionTbl.put(repoId, latestIndexedRevision);
                            }
                        }
                        finally {
                            reader.close();
                        }
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to index repository '" + subversionManager.getDisplayName() + "'"), (Throwable)e);
                }
                catch (RuntimeException e) {
                    log.warn((Object)("Unable to index repository '" + subversionManager.getDisplayName() + "'"), (Throwable)e);
                }
            }
        }
    }

    protected boolean isKeyInString(SVNLogEntry logEntry) {
        String logMessageUpperCase = StringUtils.upperCase((String)logEntry.getMessage());
        return JiraKeyUtils.isKeyInString((String)logMessageUpperCase);
    }

    protected Long getLatestIndexedRevision(long repoId) {
        return this.latestIndexedRevisionTbl.get(new Long(repoId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDocument(long repoId, long revisionNumber, IndexReader reader) throws IOException {
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            TermQuery repoQuery = new TermQuery(new Term(FIELD_REPOSITORY, Long.toString(repoId)));
            TermQuery revQuery = new TermQuery(new Term(FIELD_REVISIONNUMBER, Long.toString(revisionNumber)));
            BooleanQuery repoAndRevQuery = new BooleanQuery();
            repoAndRevQuery.add((Query)repoQuery, BooleanClause.Occur.MUST);
            repoAndRevQuery.add((Query)revQuery, BooleanClause.Occur.MUST);
            Hits hits = searcher.search((Query)repoAndRevQuery);
            if (hits.length() == 1) {
                boolean bl = true;
                return bl;
            }
            if (hits.length() == 0) {
                boolean bl = false;
                return bl;
            }
            log.error((Object)("Found MORE than one document for revision: " + revisionNumber + ", repository=" + repoId));
            boolean bl = true;
            return bl;
        }
        finally {
            searcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateLastRevisionIndexed(long repoId) throws IndexException, IOException {
        IndexReader reader;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Updating last revision indexed.");
        }
        long latestIndexedRevision = this.latestIndexedRevisionTbl.get(repoId);
        String indexPath = this.getIndexPath();
        try {
            reader = IndexReader.open((String)indexPath);
        }
        catch (IOException e) {
            log.error((Object)("Problem with path " + indexPath + ": " + e.getMessage()), (Throwable)e);
            throw new IndexException("Problem with path " + indexPath + ": " + e.getMessage(), (Exception)e);
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            Hits hits = searcher.search((Query)new TermQuery(new Term(FIELD_REPOSITORY, Long.toString(repoId))));
            for (int i = 0; i < hits.length(); ++i) {
                Document doc = hits.doc(i);
                long revision = Long.parseLong(doc.get(FIELD_REVISIONNUMBER));
                if (revision <= latestIndexedRevision) continue;
                latestIndexedRevision = revision;
            }
            log.debug((Object)("latestIndRev for " + repoId + " = " + latestIndexedRevision));
            this.latestIndexedRevisionTbl.put(repoId, latestIndexedRevision);
        }
        finally {
            reader.close();
        }
        return latestIndexedRevision;
    }

    protected Document getDocument(long repoId, SVNLogEntry logEntry) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(FIELD_MESSAGE, logEntry.getMessage(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        if (logEntry.getAuthor() != null) {
            doc.add((Fieldable)new Field(FIELD_AUTHOR, logEntry.getAuthor(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        doc.add((Fieldable)new Field(FIELD_REPOSITORY, Long.toString(repoId), Field.Store.YES, Field.Index.UN_TOKENIZED));
        doc.add((Fieldable)new Field(FIELD_REVISIONNUMBER, Long.toString(logEntry.getRevision()), Field.Store.YES, Field.Index.UN_TOKENIZED));
        if (logEntry.getDate() != null) {
            doc.add((Fieldable)new Field(FIELD_DATE, DateField.dateToString((Date)logEntry.getDate()), Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        List<String> keys = this.getIssueKeysFromString(logEntry);
        HashMap<String, String> projects = new HashMap<String, String>();
        for (String issueKey : keys) {
            doc.add((Fieldable)new Field(FIELD_ISSUEKEY, issueKey, Field.Store.YES, Field.Index.UN_TOKENIZED));
            String projectKey = this.getProjectKeyFromIssueKey(issueKey);
            if (projects.containsKey(projectKey)) continue;
            projects.put(projectKey, projectKey);
            doc.add((Fieldable)new Field(FIELD_PROJECTKEY, projectKey, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        return doc;
    }

    protected String getProjectKeyFromIssueKey(String issueKey) {
        String issueKeyUpperCase = StringUtils.upperCase((String)issueKey);
        return JiraKeyUtils.getFastProjectKeyFromIssueKey((String)issueKeyUpperCase);
    }

    protected List<String> getIssueKeysFromString(SVNLogEntry logEntry) {
        String logMessageUpperCase = StringUtils.upperCase((String)logEntry.getMessage());
        return JiraKeyUtils.getIssueKeysFromString((String)logMessageUpperCase);
    }

    public Map<Long, List<SVNLogEntry>> getLogEntriesByRepository(Issue issue) throws IndexException, IOException {
        return this.getLogEntriesByRepository(issue, 0, Integer.MAX_VALUE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<SVNLogEntry>> getLogEntriesByRepository(Issue issue, int startIndex, int pageSize, boolean ascending) throws IndexException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving revisions for : " + issue.getKey()));
        }
        if (!this.indexDirectoryExists()) {
            log.warn((Object)"The indexes for the subversion plugin have not yet been created.");
            return null;
        }
        IndexReader reader = this.indexAccessor.getIndexReader(this.getIndexPath());
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            Hits hits = searcher.search(this.createQueryByIssueKey(issue), new Sort(new SortField(FIELD_DATE, 3, !ascending)));
            LinkedHashMap<Long, List<SVNLogEntry>> logEntries = new LinkedHashMap<Long, List<SVNLogEntry>>(hits.length());
            int endIndex = startIndex + pageSize;
            for (int i = 0; i < hits.length(); ++i) {
                long revision;
                if (i < startIndex || i >= endIndex) continue;
                Document doc = hits.doc(i);
                long repositoryId = Long.parseLong(doc.get(FIELD_REPOSITORY));
                SubversionManager manager = this.multipleSubversionRepositoryManager.getRepository(repositoryId);
                SVNLogEntry logEntry = manager.getLogEntry(revision = Long.parseLong(doc.get(FIELD_REVISIONNUMBER)));
                if (logEntry == null) {
                    log.error((Object)("Could not find log message for revision: " + Long.parseLong(doc.get(FIELD_REVISIONNUMBER))));
                    continue;
                }
                ArrayList<SVNLogEntry> entries = (ArrayList<SVNLogEntry>)logEntries.get(repositoryId);
                if (entries == null) {
                    entries = new ArrayList<SVNLogEntry>();
                    logEntries.put(repositoryId, entries);
                }
                entries.add(logEntry);
            }
            LinkedHashMap<Long, List<SVNLogEntry>> linkedHashMap = logEntries;
            return linkedHashMap;
        }
        finally {
            searcher.close();
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<SVNLogEntry>> getLogEntriesByProject(String projectKey, User user, int startIndex, int pageSize) throws IndexException, IOException {
        LinkedHashMap<Long, List<SVNLogEntry>> logEntries;
        if (!this.indexDirectoryExists()) {
            log.warn((Object)"getLogEntriesByProject() The indexes for the subversion plugin have not yet been created.");
            return null;
        }
        TermQuery query = new TermQuery(new Term(FIELD_PROJECTKEY, projectKey));
        IndexReader reader = this.indexAccessor.getIndexReader(this.getIndexPath());
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            Hits hits = searcher.search((Query)query, (Filter)new ProjectRevisionFilter(this.issueManager, this.permissionManager, user, projectKey), new Sort(FIELD_DATE, true));
            if (hits == null) {
                log.info((Object)"getLogEntriesByProject() No matches -- returning null.");
                Map<Long, List<SVNLogEntry>> map = null;
                return map;
            }
            logEntries = new LinkedHashMap<Long, List<SVNLogEntry>>();
            int endIndex = startIndex + pageSize;
            int j = hits.length();
            for (int i = 0; i < j; ++i) {
                long revision;
                if (i < startIndex || i >= endIndex) continue;
                Document doc = hits.doc(i);
                long repositoryId = Long.parseLong(doc.get(FIELD_REPOSITORY));
                SubversionManager manager = this.multipleSubversionRepositoryManager.getRepository(repositoryId);
                SVNLogEntry logEntry = manager.getLogEntry(revision = Long.parseLong(doc.get(FIELD_REVISIONNUMBER)));
                if (logEntry == null) {
                    log.error((Object)("getLogEntriesByProject() Could not find log message for revision: " + revision));
                    continue;
                }
                ArrayList<SVNLogEntry> entries = (ArrayList<SVNLogEntry>)logEntries.get(repositoryId);
                if (entries == null) {
                    entries = new ArrayList<SVNLogEntry>();
                    logEntries.put(repositoryId, entries);
                }
                entries.add(logEntry);
            }
        }
        finally {
            searcher.close();
            reader.close();
        }
        return logEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<SVNLogEntry>> getLogEntriesByVersion(Version version, User user, int startIndex, int pageSize) throws IndexException, IOException {
        LinkedHashMap<Long, List<SVNLogEntry>> logEntries;
        TermQuery termQuery;
        if (!this.indexDirectoryExists()) {
            log.warn((Object)"getLogEntriesByVersion() The indexes for the subversion plugin have not yet been created.");
            return null;
        }
        HashSet issues = new HashSet();
        try {
            issues.addAll(this.versionManager.getFixIssues(version));
            issues.addAll(this.versionManager.getAffectsIssues(version));
        }
        catch (GenericEntityException e) {
            log.error((Object)("getLogEntriesByVersion() Caught exception while looking up issues related to version " + version.getName() + "!"), (Throwable)e);
        }
        int maxClauses = BooleanQuery.getMaxClauseCount();
        if (issues.size() > maxClauses) {
            BooleanQuery.setMaxClauseCount((int)issues.size());
        }
        BooleanQuery query = new BooleanQuery();
        HashSet<String> permittedIssueKeys = new HashSet<String>();
        for (GenericValue issue : issues) {
            String key = issue.getString(FIELD_ISSUEKEY);
            MutableIssue theIssue = this.issueManager.getIssueObject(key);
            if (!this.permissionManager.hasPermission(29, (Issue)theIssue, user)) continue;
            termQuery = new TermQuery(new Term(FIELD_ISSUEKEY, key));
            query.add((Query)termQuery, BooleanClause.Occur.SHOULD);
            permittedIssueKeys.add(key);
        }
        IndexReader reader = this.indexAccessor.getIndexReader(this.getIndexPath());
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            Hits hits = searcher.search((Query)query, (Filter)new PermittedIssuesRevisionFilter(this.issueManager, this.permissionManager, user, permittedIssueKeys), new Sort(FIELD_DATE, true));
            if (hits == null) {
                log.info((Object)"getLogEntriesByVersion() No matches -- returning null.");
                termQuery = null;
                return termQuery;
            }
            logEntries = new LinkedHashMap<Long, List<SVNLogEntry>>();
            int endDocIndex = startIndex + pageSize;
            int j = hits.length();
            for (int i = 0; i < j; ++i) {
                ArrayList<SVNLogEntry> entries;
                long revision;
                if (i < startIndex || i >= endDocIndex) continue;
                Document doc = hits.doc(i);
                long repositoryId = Long.parseLong(doc.get(FIELD_REPOSITORY));
                SubversionManager manager = this.multipleSubversionRepositoryManager.getRepository(repositoryId);
                SVNLogEntry logEntry = manager.getLogEntry(revision = Long.parseLong(doc.get(FIELD_REVISIONNUMBER)));
                if (logEntry == null) {
                    log.error((Object)("getLogEntriesByVersion() Could not find log message for revision: " + Long.parseLong(doc.get(FIELD_REVISIONNUMBER))));
                }
                if ((entries = (ArrayList<SVNLogEntry>)logEntries.get(repositoryId)) == null) {
                    entries = new ArrayList<SVNLogEntry>();
                    logEntries.put(repositoryId, entries);
                }
                entries.add(logEntry);
            }
        }
        finally {
            searcher.close();
            reader.close();
            BooleanQuery.setMaxClauseCount((int)maxClauses);
        }
        return logEntries;
    }

    public void addRepository(SubversionManager subversionInstance) {
        this.initializeLatestIndexedRevisionCache(subversionInstance);
        try {
            this.updateIndex();
        }
        catch (Exception e) {
            throw new InfrastructureException("Could not index repository", (Throwable)e);
        }
    }

    public void removeEntries(SubversionManager subversionInstance) throws IOException, IndexException, SVNException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleteing revisions for : " + subversionInstance.getRoot()));
        }
        if (!this.indexDirectoryExists()) {
            log.warn((Object)"The indexes for the subversion plugin have not yet been created.");
        } else {
            long repoId = subversionInstance.getId();
            IndexWriter writer = null;
            try {
                writer = this.indexAccessor.getIndexWriter(this.getIndexPath(), false, (Analyzer)ANALYZER);
                writer.deleteDocuments(new Term(FIELD_REPOSITORY, Long.toString(repoId)));
                this.initializeLatestIndexedRevisionCache(subversionInstance);
            }
            catch (IndexException ie) {
                if (log.isEnabledFor((Priority)Level.ERROR)) {
                    log.error((Object)("Unable to open index. Perhaps the index is corrupted. It might be possible to fix the problem by removing the index directory (" + this.getIndexPath() + ")"), (Throwable)ie);
                }
                throw ie;
            }
            finally {
                block15: {
                    if (null != writer) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioe) {
                            if (!log.isEnabledFor((Priority)Level.WARN)) break block15;
                            log.warn((Object)"Unable to close index.", (Throwable)ioe);
                        }
                    }
                }
            }
        }
    }

    protected Query createQueryByIssueKey(Issue issue) {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(FIELD_ISSUEKEY, issue.getKey())), BooleanClause.Occur.SHOULD);
        Collection previousIssueKeys = this.changeHistoryManager.getPreviousIssueKeys(issue.getId());
        for (String previousIssueKey : previousIssueKeys) {
            TermQuery termQuery = new TermQuery(new Term(FIELD_ISSUEKEY, previousIssueKey));
            query.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return query;
    }
}

