/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.plugin.ext.subversion.revisions.AbstractRevisionFilter;
import com.atlassian.jira.security.PermissionManager;
import com.opensymphony.user.User;
import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public class ProjectRevisionFilter
extends AbstractRevisionFilter {
    private final String projectKey;

    public ProjectRevisionFilter(IssueManager issueManager, PermissionManager permissionManager, User user, String projectKey) {
        super(issueManager, permissionManager, user);
        this.projectKey = projectKey;
    }

    public BitSet bits(IndexReader indexReader) throws IOException {
        BitSet bitSet = new BitSet(indexReader.maxDoc());
        TermDocs termDocs = indexReader.termDocs(new Term("project", this.projectKey));
        while (termDocs.next()) {
            int docId = termDocs.doc();
            Document theDoc = indexReader.document(docId, this.issueKeysFieldSelector);
            boolean allow = false;
            String[] issueKeys = theDoc.getValues("key");
            if (null != issueKeys) {
                for (String issueKey : issueKeys) {
                    MutableIssue anIssue = this.issueManager.getIssueObject(StringUtils.upperCase((String)issueKey));
                    if (null == anIssue || !this.permissionManager.hasPermission(29, (Issue)anIssue, this.user)) continue;
                    allow = true;
                    break;
                }
            }
            bitSet.set(docId, allow);
        }
        return bitSet;
    }
}

