/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.action;

import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.action.AddSubversionRepositoryAction;

public class UpdateSubversionRepositoryAction
extends AddSubversionRepositoryAction {
    private long repoId = -1L;

    public UpdateSubversionRepositoryAction(MultipleSubversionRepositoryManager multipleRepoManager) {
        super(multipleRepoManager);
    }

    public String doDefault() {
        if ("error".equals(super.doDefault())) {
            return "error";
        }
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        if (this.repoId == -1L) {
            this.addErrorMessage(this.getText("subversion.repository.id.missing"));
            return "error";
        }
        SubversionManager repository = this.getMultipleRepoManager().getRepository(this.repoId);
        if (repository == null) {
            this.addErrorMessage(this.getText("subversion.repository.does.not.exist", Long.toString(this.repoId)));
            return "error";
        }
        this.setDisplayName(repository.getDisplayName());
        this.setRoot(repository.getRoot());
        if (repository.getViewLinkFormat() != null) {
            this.setWebLinkType(repository.getViewLinkFormat().getType());
            this.setChangesetFormat(repository.getViewLinkFormat().getChangesetFormat());
            this.setViewFormat(repository.getViewLinkFormat().getViewFormat());
            this.setFileAddedFormat(repository.getViewLinkFormat().getFileAddedFormat());
            this.setFileDeletedFormat(repository.getViewLinkFormat().getFileDeletedFormat());
            this.setFileModifiedFormat(repository.getViewLinkFormat().getFileModifiedFormat());
            this.setFileReplacedFormat(repository.getViewLinkFormat().getFileReplacedFormat());
        }
        this.setUsername(repository.getUsername());
        this.setPassword(repository.getPassword());
        this.setPrivateKeyFile(repository.getPrivateKeyFile());
        this.setRevisionCacheSize(new Integer(repository.getRevisioningCacheSize()));
        this.setRevisionIndexing(new Boolean(repository.isRevisionIndexing()));
        return "input";
    }

    public String doExecute() {
        if (!this.hasPermissions()) {
            this.addErrorMessage(this.getText("subversion.admin.privilege.required"));
            return "error";
        }
        if (this.repoId == -1L) {
            return this.getRedirect("ViewSubversionRepositories.jspa");
        }
        SubversionManager subversionManager = this.getMultipleRepoManager().updateRepository(this.repoId, this);
        if (!subversionManager.isActive()) {
            this.repoId = subversionManager.getId();
            this.addErrorMessage(subversionManager.getInactiveMessage());
            this.addErrorMessage(this.getText("admin.errors.occured.when.updating"));
            return "error";
        }
        return this.getRedirect("ViewSubversionRepositories.jspa");
    }

    public long getRepoId() {
        return this.repoId;
    }

    public void setRepoId(long repoId) {
        this.repoId = repoId;
    }
}

