<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/webwork" prefix="ww" %>
<html>
<head>
    <title>
        <ww:text name="menu.viewapplication.label"/>
    </title>
    <meta name="section" content="applications"/>
    <meta name="pagename" content="view"/>
    <meta name="help.url" content="<ww:text name="help.application.view.details"/>"/>

</head>
<body>

<h2 id="application-name">
    <img class="application-icon" style="padding-bottom:3px;" title="<ww:property value="getImageTitle(application.active, application.type)"/>"
         alt="<ww:property value="getImageTitle(application.active, application.type)"/>" src="<ww:property value="getImageLocation(application.active, application.type)" />"/>
    <ww:property value="application.name"/>
</h2>

<div class="page-content">

    <ww:component template="application_tab_headers.jsp">
        <ww:param name="pagekey" value="'application-details'"/>
    </ww:component>

    <div class="tabContent static" id="tab1">
        <div class="crowdForm">
            <form name="applicationDetails" method="post"
                  action="<ww:url namespace="/console/secure/application" action="update" method="update" includeParams="none" />">

                <div class="formBodyNoTop">

                    <ww:component template="form_tab_messages.jsp">
                        <ww:param name="tabID" value="1"/>
                    </ww:component>

                    <input type="hidden" name="ID" value="<ww:property value="ID" />"/>

                    <ww:textfield name="name" size="35px;" disabled="application.permanent">
                        <ww:param name="required" value="!application.permanent"/>
                        <ww:param name="label" value="getText('application.name.label')"/>
                        <ww:param name="description">
                            <ww:property value="getText('application.name.description')"/>
                        </ww:param>
                    </ww:textfield>

                    <!-- disabled fields aren't set back to the server -->
                    <ww:if test="application.permanent">
                        <input type="hidden" name="name" value="<ww:property value="name"/>"/>
                    </ww:if>

                    <ww:textfield name="applicationDescription" size="35px;">
                        <ww:param name="label" value="getText('application.description.label')"/>
                        <ww:param name="description">
                            <ww:property value="getText('application.description.description')"/>
                        </ww:param>
                    </ww:textfield>

                    <ww:component template="form_row.jsp">
                        <ww:param name="label" value="getText('application.type.label')"/>
                        <ww:param name="value">
                            <ww:property value="application.type.displayName"/>
                        </ww:param>
                    </ww:component>

                    <ww:checkbox name="active" disabled="crowdApplication">
                        <ww:param name="label" value="getText('application.active.label')"/>
                    </ww:checkbox>

                    <ww:component template="form_row.jsp">
                        <ww:param name="label" value="getText('application.conception.label')"/>
                        <ww:param name="value">
                            <ww:date format="dd MMM yyyy, HH:mm:ss" name="application.createdDate"/>
                        </ww:param>
                    </ww:component>

                    <ww:component template="form_row.jsp">
                        <ww:param name="label" value="getText('application.lastmodified.label')"/>
                        <ww:param name="value">
                            <ww:date format="dd MMM yyyy, HH:mm:ss" name="application.updatedDate"/>
                        </ww:param>
                    </ww:component>

                    <ww:if test="!pluginApplication">
                        <ww:password name="password" size="35px;">
                            <ww:param name="label" value="getText('password.label')"/>
                            <ww:param name="description">
                                <ww:property value="getText('application.password.description')"/>
                            </ww:param>
                        </ww:password>

                        <ww:password name="passwordConfirm" size="35px;">
                            <ww:param name="label" value="getText('passwordconfirm.label')"/>
                        </ww:password>
                    </ww:if>

                </div>

                <div class="formFooter wizardFooter">

                    <div class="buttons">

                        <input type="submit" class="button" value="<ww:property value="getText('update.label')"/> &raquo;"/>
                        <input type="button" class="button" value="<ww:property value="getText('cancel.label')"/>"
                               onClick="window.location='<ww:url namespace="/console/secure/application" action="viewdetails" method="default" includeParams="none"><ww:param name="ID" value="ID"/><ww:param name="tab" value="1"/></ww:url>'"/>
                    </div>
                </div>

            </form>

        </div>

    </div>

</div>
</body>
</html>