/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.AbstractDelegatingPlugin;
import com.atlassian.plugin.loaders.DirectoryPluginLoader;
import com.atlassian.plugin.util.FileUtils;
import java.io.File;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundledPluginLoader
extends DirectoryPluginLoader {
    public BundledPluginLoader(URL zipUrl, File pluginPath, List<PluginFactory> pluginFactories, PluginEventManager eventManager) {
        super(pluginPath, pluginFactories, eventManager);
        if (zipUrl == null) {
            throw new IllegalArgumentException("Bundled zip url cannot be null");
        }
        FileUtils.conditionallyExtractZipFile(zipUrl, pluginPath);
    }

    @Override
    protected Plugin postProcess(Plugin plugin) {
        return new BundledPluginDelegate(plugin);
    }

    private static class BundledPluginDelegate
    extends AbstractDelegatingPlugin {
        public BundledPluginDelegate(Plugin delegate) {
            super(delegate);
        }

        public boolean isBundledPlugin() {
            return true;
        }

        public boolean isDeleteable() {
            return false;
        }
    }
}

