/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.poller.AbstractQuartzDirectoryPollerManager;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerJob;
import java.util.Date;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzDirectoryPollerManager
extends AbstractQuartzDirectoryPollerManager {
    private final Scheduler scheduler;

    public QuartzDirectoryPollerManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected JobDetail buildJobDetail(DirectoryPoller poller) throws DirectoryMonitorRegistrationException {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(this.getJobName(poller.getDirectoryID()));
        jobDetail.setGroup("DirectoryPoller");
        jobDetail.setJobClass(DirectoryPollerJob.class);
        jobDetail.setVolatility(true);
        jobDetail.setDurability(true);
        jobDetail.getJobDataMap().put((Object)"DIRECTORY_POLLER", (Object)poller);
        return jobDetail;
    }

    protected Trigger buildTrigger(DirectoryPoller poller, JobDetail jobDetail) throws DirectoryMonitorRegistrationException {
        SimpleTrigger trigger = new SimpleTrigger();
        trigger.setName(jobDetail.getName());
        trigger.setJobName(jobDetail.getName());
        trigger.setGroup("DirectoryPoller");
        trigger.setJobGroup("DirectoryPoller");
        trigger.setVolatility(jobDetail.isVolatile());
        trigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
        long pollingIntervalMillis = poller.getPollingInterval() * 1000L;
        trigger.setRepeatInterval(pollingIntervalMillis);
        trigger.setStartTime(new Date(System.currentTimeMillis() + 5000L));
        return trigger;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }
}

