/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.manager.lock.DirectoryLockManager;
import com.atlassian.event.api.EventPublisher;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectorySynchroniserImpl
implements DirectorySynchroniser {
    private static final Logger log = LoggerFactory.getLogger(DirectorySynchroniser.class);
    private final DirectoryLockManager directoryLockManager;
    private final DirectoryDao directoryDao;
    private final DirectorySynchroniserHelper directorySynchroniserHelper;
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final EventPublisher eventPublisher;

    public DirectorySynchroniserImpl(DirectoryLockManager directoryLockManager, DirectoryDao directoryDao, DirectorySynchroniserHelper directorySynchroniserHelper, SynchronisationStatusManager synchronisationStatusManager, EventPublisher eventPublisher) {
        this.directoryLockManager = directoryLockManager;
        this.directoryDao = directoryDao;
        this.directorySynchroniserHelper = directorySynchroniserHelper;
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronise(SynchronisableDirectory remoteDirectory, SynchronisationMode mode) throws DirectoryNotFoundException, OperationFailedException {
        long directoryId = remoteDirectory.getDirectoryId();
        Directory directory = this.findDirectoryById(directoryId);
        if (!directory.isActive()) {
            log.debug("Request to synchronise directory [ {} ] is returning silently because the directory is not active.", (Object)directoryId);
            return;
        }
        log.debug("request to synchronise directory [ {} ]", (Object)directoryId);
        Lock lock = this.directoryLockManager.getLock(directoryId);
        if (lock.tryLock()) {
            try {
                this.directorySynchroniserHelper.updateSyncStartTime(remoteDirectory);
                this.synchronisationStatusManager.syncStarted(directory);
                try {
                    remoteDirectory.synchroniseCache(mode, this.synchronisationStatusManager);
                    this.synchronisationStatusManager.syncStatus(directoryId, "directory.caching.sync.completed.ok", new Serializable[0]);
                }
                catch (OperationFailedException e) {
                    this.synchronisationStatusManager.syncStatus(directoryId, "directory.caching.sync.completed.error", new Serializable[0]);
                    throw e;
                }
                finally {
                    this.directorySynchroniserHelper.updateSyncEndTime(remoteDirectory);
                    this.synchronisationStatusManager.syncFinished(directoryId);
                }
            }
            finally {
                lock.unlock();
            }
            this.eventPublisher.publish((Object)new RemoteDirectorySynchronisedEvent((Object)this, (RemoteDirectory)remoteDirectory));
        } else {
            log.debug("directory [ {} ] already synchronising", (Object)directoryId);
        }
    }

    public boolean isSynchronising(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.isSynchronising(directoryId);
    }

    private Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directoryDao.findById(directoryId);
    }
}

