/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalHybridDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableDirectoryInstanceLoader
implements DirectoryInstanceLoader {
    private static final Logger log = LoggerFactory.getLogger(CacheableDirectoryInstanceLoader.class);
    private final InternalHybridDirectoryInstanceLoader delegate;
    private final EventPublisher eventPublisher;
    private final ConcurrentMap<Long, RemoteDirectory> directoryCache;

    public CacheableDirectoryInstanceLoader(InternalHybridDirectoryInstanceLoader delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.directoryCache = CopyOnWriteMap.builder().newHashMap();
        this.eventPublisher.register((Object)this);
    }

    public RemoteDirectory getDirectory(Directory directory) throws DirectoryInstantiationException {
        boolean cacheEnabled = Boolean.parseBoolean((String)directory.getAttributes().get("com.atlassian.crowd.directory.sync.cache.enabled"));
        if (cacheEnabled) {
            return this.delegate.getDirectory(directory);
        }
        Long id = directory.getId();
        RemoteDirectory remoteDirectory = (RemoteDirectory)this.directoryCache.get(id);
        if (remoteDirectory != null) {
            return remoteDirectory;
        }
        remoteDirectory = this.delegate.getRawDirectory(id, directory.getImplementationClass(), directory.getAttributes());
        RemoteDirectory existingDirectory = this.directoryCache.putIfAbsent(id, remoteDirectory);
        return existingDirectory != null ? existingDirectory : remoteDirectory;
    }

    public RemoteDirectory getRawDirectory(Long id, String className, Map<String, String> attributes) throws DirectoryInstantiationException {
        return this.delegate.getRawDirectory(id, className, attributes);
    }

    public boolean canLoad(String className) {
        return this.delegate.canLoad(className);
    }

    @EventListener
    public void handleEvent(DirectoryUpdatedEvent event) {
        Directory directory = event.getDirectory();
        this.directoryCache.remove(directory.getId());
    }

    @EventListener
    public void handleEvent(DirectoryDeletedEvent event) {
        Directory directory = event.getDirectory();
        this.directoryCache.remove(directory.getId());
    }

    @EventListener
    public void handleEvent(XMLRestoreFinishedEvent event) {
        this.directoryCache.clear();
        log.debug("Directory Cache cleared.");
    }
}

