/*
 * Decompiled with CFR 0.152.
 */
package ognl.internal;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.concurrent.ConcurrentMap;
import ognl.ClassCacheInspector;
import ognl.internal.ClassCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentClassCache<T>
implements ClassCache<T> {
    private final ConcurrentMap<Class<?>, T> map = CopyOnWriteMap.builder().newHashMap();
    private volatile ClassCacheInspector classCacheInspector;

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public T get(Class<?> key) {
        return (T)this.map.get(key);
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @Override
    public T put(Class<?> key, T value) {
        ClassCacheInspector cacheInspector = this.classCacheInspector;
        if (cacheInspector != null && !cacheInspector.shouldCache(key)) {
            return null;
        }
        return this.map.put(key, value);
    }

    @Override
    public T putIfAbsent(Class<?> key, T value) {
        ClassCacheInspector cacheInspector = this.classCacheInspector;
        if (cacheInspector != null && !cacheInspector.shouldCache(key)) {
            return null;
        }
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public void setClassInspector(ClassCacheInspector classCacheInspector) {
        this.classCacheInspector = classCacheInspector;
    }
}

