/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.lifecycle;

import com.atlassian.config.lifecycle.DefaultLifecycleContext;
import com.atlassian.config.lifecycle.LifecycleContext;
import com.atlassian.config.lifecycle.LifecycleItem;
import com.atlassian.config.lifecycle.LifecycleManager;
import com.atlassian.config.lifecycle.LifecyclePluginModuleDescriptor;
import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.config.lifecycle.events.ApplicationStoppedEvent;
import com.atlassian.config.lifecycle.events.ApplicationStoppingEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.PluginManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLifecycleManager
implements LifecycleManager {
    private static Logger log = Logger.getLogger(LifecycleManager.class);
    private PluginManager pluginManager;
    private EventPublisher eventPublisher;

    @Override
    public void startUp(ServletContext servletContext) {
        List<LifecyclePluginModuleDescriptor> moduleDescriptors = this.getLifecyclePluginModuleDescriptors();
        DefaultLifecycleContext context = new DefaultLifecycleContext(servletContext);
        LifecyclePluginModuleDescriptor currentDescriptor = null;
        try {
            Iterator<LifecyclePluginModuleDescriptor> i$ = moduleDescriptors.iterator();
            while (i$.hasNext()) {
                LifecyclePluginModuleDescriptor descriptor;
                currentDescriptor = descriptor = i$.next();
                log.info((Object)("Starting: " + descriptor));
                ((LifecycleItem)descriptor.getModule()).startup(context);
            }
            this.eventPublisher.publish((Object)new ApplicationStartedEvent(this));
        }
        catch (Throwable t) {
            this.panicAndShutdown(t, context, currentDescriptor);
        }
    }

    @Override
    public void shutDown(ServletContext servletContext) {
        this.shutDown(servletContext, null);
    }

    private void panicAndShutdown(Throwable t, LifecycleContext context, LifecyclePluginModuleDescriptor descriptor) {
        String errorString = "Unable to start up Confluence. Fatal error during startup sequence: " + descriptor + " - " + t;
        log.fatal((Object)errorString, t);
        context.getAgentJohnson().addEvent(new Event(EventType.get((String)"startup"), errorString, "fatal"));
        this.shutDown(context.getServletContext(), descriptor.getCompleteKey());
    }

    private void shutDown(ServletContext servletContext, String startingPluginKey) {
        this.eventPublisher.publish((Object)new ApplicationStoppingEvent(this));
        List<LifecyclePluginModuleDescriptor> moduleDescriptors = this.getLifecyclePluginModuleDescriptors();
        Collections.reverse(moduleDescriptors);
        DefaultLifecycleContext context = new DefaultLifecycleContext(servletContext);
        boolean started = startingPluginKey == null;
        for (LifecyclePluginModuleDescriptor descriptor : moduleDescriptors) {
            if (!started) {
                if (!descriptor.getCompleteKey().equals(startingPluginKey)) continue;
                started = true;
            }
            log.info((Object)("Shutting down: " + descriptor));
            LifecycleItem item = (LifecycleItem)descriptor.getModule();
            try {
                item.shutdown(context);
            }
            catch (Throwable t) {
                log.error((Object)("Error running shutdown plugin: " + descriptor.getDescription() + " - " + t), t);
            }
        }
        this.eventPublisher.publish((Object)new ApplicationStoppedEvent(this));
    }

    private List<LifecyclePluginModuleDescriptor> getLifecyclePluginModuleDescriptors() {
        List modules = this.pluginManager.getEnabledModuleDescriptorsByClass(LifecyclePluginModuleDescriptor.class);
        Collections.sort(modules);
        return modules;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

