/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.impl;

import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.RuntimeConfiguration;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfiguration
implements Configuration {
    protected static final Log LOG = LogFactory.getLog((Class)DefaultConfiguration.class);
    private Map packageContexts = new LinkedHashMap();
    protected RuntimeConfiguration runtimeConfiguration;

    public PackageConfig getPackageConfig(String name) {
        return (PackageConfig)this.packageContexts.get(name);
    }

    public Set getPackageConfigNames() {
        return this.packageContexts.keySet();
    }

    public Map getPackageConfigs() {
        return this.packageContexts;
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public void addPackageConfig(String name, PackageConfig packageContext) {
        PackageConfig check = (PackageConfig)this.packageContexts.get(name);
        if (check != null) {
            LOG.error((Object)("The package name '" + name + "' is already been used by another package: " + check));
        }
        this.packageContexts.put(name, packageContext);
    }

    public void destroy() {
    }

    public void rebuildRuntimeConfiguration() {
        this.runtimeConfiguration = this.buildRuntimeConfiguration();
    }

    public synchronized void reload() throws ConfigurationException {
        this.packageContexts.clear();
        Iterator iterator = ConfigurationManager.getConfigurationProviders().iterator();
        while (iterator.hasNext()) {
            ConfigurationProvider provider = (ConfigurationProvider)iterator.next();
            provider.init(this);
        }
        this.rebuildRuntimeConfiguration();
    }

    public void removePackageConfig(String name) {
        PackageConfig toBeRemoved = (PackageConfig)this.packageContexts.get(name);
        if (toBeRemoved != null) {
            Iterator iterator = this.packageContexts.values().iterator();
            while (iterator.hasNext()) {
                PackageConfig packageContext = (PackageConfig)iterator.next();
                packageContext.removeParent(toBeRemoved);
            }
        }
    }

    protected synchronized RuntimeConfiguration buildRuntimeConfiguration() throws ConfigurationException {
        LinkedHashMap namespaceActionConfigs = new LinkedHashMap();
        LinkedHashMap<String, String> namespaceConfigs = new LinkedHashMap<String, String>();
        Iterator iterator = this.packageContexts.values().iterator();
        while (iterator.hasNext()) {
            PackageConfig packageContext = (PackageConfig)iterator.next();
            if (packageContext.isAbstract()) continue;
            String namespace = packageContext.getNamespace();
            LinkedHashMap<String, ActionConfig> configs = (LinkedHashMap<String, ActionConfig>)namespaceActionConfigs.get(namespace);
            if (configs == null) {
                configs = new LinkedHashMap<String, ActionConfig>();
            }
            Map actionConfigs = packageContext.getAllActionConfigs();
            Iterator actionIterator = actionConfigs.keySet().iterator();
            while (actionIterator.hasNext()) {
                String actionName = (String)actionIterator.next();
                ActionConfig baseConfig = (ActionConfig)actionConfigs.get(actionName);
                configs.put(actionName, this.buildFullActionConfig(packageContext, baseConfig));
            }
            namespaceActionConfigs.put(namespace, configs);
            if (packageContext.getFullDefaultActionRef() == null) continue;
            namespaceConfigs.put(namespace, packageContext.getFullDefaultActionRef());
        }
        return new RuntimeConfigurationImpl(namespaceActionConfigs, namespaceConfigs);
    }

    private void setDefaultResults(Map results, PackageConfig packageContext) {
        String defaultResult = packageContext.getFullDefaultResultType();
        Iterator iterator = results.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != null) continue;
            ResultTypeConfig resultTypeConfig = (ResultTypeConfig)packageContext.getAllResultTypeConfigs().get(defaultResult);
            entry.setValue(resultTypeConfig.getClazz());
        }
    }

    private ActionConfig buildFullActionConfig(PackageConfig packageContext, ActionConfig baseConfig) throws ConfigurationException {
        String defaultInterceptorRefName;
        TreeMap params = new TreeMap(baseConfig.getParams());
        TreeMap results = new TreeMap();
        if (baseConfig.getPackageName().equals(packageContext.getName())) {
            results.putAll(packageContext.getAllGlobalResults());
            results.putAll(baseConfig.getResults());
        } else {
            PackageConfig baseConfigPackageConfig = (PackageConfig)this.packageContexts.get(baseConfig.getPackageName());
            if (baseConfigPackageConfig != null) {
                results.putAll(baseConfigPackageConfig.getAllGlobalResults());
            }
            results.putAll(baseConfig.getResults());
        }
        this.setDefaultResults(results, packageContext);
        ArrayList interceptors = new ArrayList(baseConfig.getInterceptors());
        if (interceptors.size() <= 0 && (defaultInterceptorRefName = packageContext.getFullDefaultInterceptorRef()) != null) {
            interceptors.addAll(InterceptorBuilder.constructInterceptorReference(packageContext, defaultInterceptorRefName, new LinkedHashMap()));
        }
        List externalRefs = baseConfig.getExternalRefs();
        List exceptionMappings = baseConfig.getExceptionMappings();
        exceptionMappings.addAll(packageContext.getAllExceptionMappingConfigs());
        ActionConfig config = new ActionConfig(baseConfig.getMethodName(), baseConfig.getClassName(), params, results, interceptors, externalRefs, exceptionMappings, packageContext.getName());
        return config;
    }

    private class RuntimeConfigurationImpl
    implements RuntimeConfiguration {
        private Map namespaceActionConfigs;
        private Map namespaceConfigs;

        public RuntimeConfigurationImpl(Map namespaceActionConfigs, Map namespaceConfigs) {
            this.namespaceActionConfigs = namespaceActionConfigs;
            this.namespaceConfigs = namespaceConfigs;
        }

        public synchronized ActionConfig getActionConfig(String namespace, String name) {
            String defaultActionRef;
            ActionConfig config = null;
            Map actions = (Map)this.namespaceActionConfigs.get(namespace == null ? "" : namespace);
            if (actions != null && (config = (ActionConfig)actions.get(name)) == null && (defaultActionRef = (String)this.namespaceConfigs.get(namespace == null ? "" : namespace)) != null) {
                config = (ActionConfig)actions.get(defaultActionRef);
            }
            if (config == null && namespace != null && !namespace.trim().equals("") && (actions = (Map)this.namespaceActionConfigs.get("")) != null && (config = (ActionConfig)actions.get(name)) == null && (defaultActionRef = (String)this.namespaceConfigs.get("")) != null) {
                config = (ActionConfig)actions.get(defaultActionRef);
            }
            return config;
        }

        public synchronized Map getActionConfigs() {
            return this.namespaceActionConfigs;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("RuntimeConfiguration - actions are\n");
            Iterator iterator = this.namespaceActionConfigs.keySet().iterator();
            while (iterator.hasNext()) {
                String namespace = (String)iterator.next();
                Map actionConfigs = (Map)this.namespaceActionConfigs.get(namespace);
                Iterator iterator2 = actionConfigs.keySet().iterator();
                while (iterator2.hasNext()) {
                    buff.append(namespace + "/" + iterator2.next() + "\n");
                }
            }
            return buff.toString();
        }
    }
}

