/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.db;

import com.atlassian.config.ApplicationConfiguration;
import java.util.Map;
import java.util.Properties;

public class HibernateConfig {
    public static final String HIBERNATE_SETUP = "hibernate.setup";
    public static final String HIBERNATE_CONFIG_PREFIX = "hibernate.";
    private ApplicationConfiguration applicationConfig;

    public void setApplicationConfig(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfig = applicationConfiguration;
    }

    public boolean isHibernateSetup() {
        return this.applicationConfig.getBooleanProperty(HIBERNATE_SETUP);
    }

    public Properties getHibernateProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.applicationConfig.getPropertiesWithPrefix(HIBERNATE_CONFIG_PREFIX));
        return props;
    }

    public boolean isMySql() {
        return this.isHibernateSetup() && ((String)this.applicationConfig.getProperty("hibernate.dialect")).endsWith("MySQLDialect");
    }

    public boolean isOracle() {
        return this.isHibernateSetup() && ((String)this.applicationConfig.getProperty("hibernate.dialect")).endsWith("OracleDialect");
    }

    public boolean isHSQL() {
        return this.isHibernateSetup() && ((String)this.applicationConfig.getProperty("hibernate.dialect")).endsWith("HSQLDialect");
    }
}

