/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.util.VersionStringComparator;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlugin
implements Plugin,
Comparable<Plugin> {
    private final Map<String, ModuleDescriptor<?>> modules = CopyOnWriteMap.builder().stableViews().newLinkedMap();
    private String name;
    private String i18nNameKey;
    private String key;
    private boolean enabledByDefault = true;
    private PluginInformation pluginInformation = new PluginInformation();
    private boolean system;
    private Resourced resources = Resources.EMPTY_RESOURCES;
    private int pluginsVersion = 1;
    private final Date dateLoaded = new Date();
    private final AtomicReference<PluginState> pluginState = new AtomicReference<PluginState>(PluginState.UNINSTALLED);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getName() {
        return !StringUtils.isBlank((String)this.name) ? this.name : (!StringUtils.isBlank((String)this.i18nNameKey) ? "" : this.getKey());
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    @Override
    public void setI18nNameKey(String i18nNameKey) {
        this.i18nNameKey = i18nNameKey;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String aPackage) {
        this.key = aPackage;
    }

    @Override
    public void addModuleDescriptor(ModuleDescriptor<?> moduleDescriptor) {
        this.modules.put(moduleDescriptor.getKey(), moduleDescriptor);
    }

    protected void removeModuleDescriptor(String key) {
        this.modules.remove(key);
    }

    @Override
    public Collection<ModuleDescriptor<?>> getModuleDescriptors() {
        return this.modules.values();
    }

    @Override
    public ModuleDescriptor<?> getModuleDescriptor(String key) {
        return this.modules.get(key);
    }

    public <T> List<ModuleDescriptor<T>> getModuleDescriptorsByModuleClass(Class<T> aClass) {
        ArrayList<ModuleDescriptor<T>> result = new ArrayList<ModuleDescriptor<T>>();
        for (ModuleDescriptor<?> moduleDescriptor : this.modules.values()) {
            Class<?> moduleClass = moduleDescriptor.getModuleClass();
            if (!aClass.isAssignableFrom(moduleClass)) continue;
            ModuleDescriptor<?> typedModuleDescriptor = moduleDescriptor;
            result.add(typedModuleDescriptor);
        }
        return result;
    }

    @Override
    public PluginState getPluginState() {
        return this.pluginState.get();
    }

    protected void setPluginState(PluginState state) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Plugin " + this.getKey() + " going from " + (Object)((Object)this.getPluginState()) + " to " + (Object)((Object)state));
        }
        this.pluginState.set(state);
    }

    protected boolean compareAndSetPluginState(PluginState requiredExistingState, PluginState desiredState) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Plugin " + this.getKey() + " trying to go from " + (Object)((Object)this.getPluginState()) + " to " + (Object)((Object)desiredState) + " but only if in " + (Object)((Object)requiredExistingState));
        }
        return this.pluginState.compareAndSet(requiredExistingState, desiredState);
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.enabledByDefault && (this.pluginInformation == null || this.pluginInformation.satisfiesMinJavaVersion());
    }

    @Override
    public void setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
    }

    @Override
    public int getPluginsVersion() {
        return this.pluginsVersion;
    }

    @Override
    public void setPluginsVersion(int pluginsVersion) {
        this.pluginsVersion = pluginsVersion;
    }

    @Override
    public PluginInformation getPluginInformation() {
        return this.pluginInformation;
    }

    @Override
    public void setPluginInformation(PluginInformation pluginInformation) {
        this.pluginInformation = pluginInformation;
    }

    @Override
    public void setResources(Resourced resources) {
        this.resources = resources != null ? resources : Resources.EMPTY_RESOURCES;
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.resources.getResourceDescriptors();
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        return this.resources.getResourceDescriptors(type);
    }

    @Override
    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    @Override
    @Deprecated
    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    @Override
    @Deprecated
    public boolean isEnabled() {
        return this.getPluginState() == PluginState.ENABLED;
    }

    @Override
    public final void enable() {
        PluginState state = this.pluginState.get();
        if (state == PluginState.ENABLED || state == PluginState.ENABLING) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Enabling plugin '" + this.getKey() + "'");
        }
        try {
            PluginState desiredState = this.enableInternal();
            if (desiredState != PluginState.ENABLED && desiredState != PluginState.ENABLING) {
                this.log.warn("Illegal state transition to " + (Object)((Object)desiredState) + " for plugin '" + this.getKey() + "' on enable()");
            }
            this.setPluginState(desiredState);
        }
        catch (PluginException ex) {
            this.log.warn("Unable to enable plugin '" + this.getKey() + "'", (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Enabled plugin '" + this.getKey() + "'");
        }
    }

    protected PluginState enableInternal() throws PluginException {
        return PluginState.ENABLED;
    }

    @Override
    public final void disable() {
        if (this.pluginState.get() == PluginState.DISABLED) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Disabling plugin '" + this.getKey() + "'");
        }
        try {
            this.disableInternal();
            this.setPluginState(PluginState.DISABLED);
        }
        catch (PluginException ex) {
            this.log.warn("Unable to disable plugin '" + this.getKey() + "'", (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Disabled plugin '" + this.getKey() + "'");
        }
    }

    protected void disableInternal() throws PluginException {
    }

    @Override
    public Set<String> getRequiredPlugins() {
        return Collections.emptySet();
    }

    @Override
    public void close() {
        this.uninstall();
    }

    @Override
    public final void install() {
        if (this.pluginState.get() == PluginState.INSTALLED) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Installing plugin '" + this.getKey() + "'");
        }
        try {
            this.installInternal();
            this.setPluginState(PluginState.INSTALLED);
        }
        catch (PluginException ex) {
            this.log.warn("Unable to install plugin '" + this.getKey() + "'", (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Installed plugin '" + this.getKey() + "'");
        }
    }

    protected void installInternal() throws PluginException {
    }

    @Override
    public final void uninstall() {
        if (this.pluginState.get() == PluginState.UNINSTALLED) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Uninstalling plugin '" + this.getKey() + "'");
        }
        try {
            this.uninstallInternal();
            this.setPluginState(PluginState.UNINSTALLED);
        }
        catch (PluginException ex) {
            this.log.warn("Unable to uninstall plugin '" + this.getKey() + "'", (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Uninstalled plugin '" + this.getKey() + "'");
        }
    }

    protected void uninstallInternal() throws PluginException {
    }

    @Override
    @Deprecated
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    @Override
    public boolean isSystemPlugin() {
        return this.system;
    }

    @Override
    public boolean containsSystemModule() {
        for (ModuleDescriptor<?> moduleDescriptor : this.modules.values()) {
            if (!moduleDescriptor.isSystemModule()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSystemPlugin(boolean system) {
        this.system = system;
    }

    @Override
    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    @Override
    public boolean isBundledPlugin() {
        return false;
    }

    @Override
    public int compareTo(Plugin otherPlugin) {
        if (otherPlugin.getKey() == null) {
            if (this.getKey() == null) {
                return 0;
            }
            return 1;
        }
        if (this.getKey() == null) {
            return -1;
        }
        if (!otherPlugin.getKey().equals(this.getKey())) {
            return this.getKey().compareTo(otherPlugin.getKey());
        }
        String thisVersion = this.cleanVersionString(this.getPluginInformation() != null ? this.getPluginInformation().getVersion() : null);
        String otherVersion = this.cleanVersionString(otherPlugin.getPluginInformation() != null ? otherPlugin.getPluginInformation().getVersion() : null);
        if (!VersionStringComparator.isValidVersionString(thisVersion)) {
            if (!VersionStringComparator.isValidVersionString(otherVersion)) {
                return 0;
            }
            return -1;
        }
        if (!VersionStringComparator.isValidVersionString(otherVersion)) {
            return 1;
        }
        return new VersionStringComparator().compare(thisVersion, otherVersion);
    }

    private String cleanVersionString(String version) {
        if (version == null || version.trim().equals("")) {
            return "0";
        }
        return version.replaceAll(" ", "");
    }

    public String toString() {
        PluginInformation info = this.getPluginInformation();
        return this.getKey() + ":" + (info == null ? "?" : info.getVersion());
    }
}

