/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask430
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask430.class);
    private ApplicationManager applicationManager;
    private final Collection<String> errors = new ArrayList<String>();

    @Override
    public String getBuildNumber() {
        return "430";
    }

    @Override
    public String getShortDescription() {
        return "Updating values for application remote addresses to allow support for IPv6";
    }

    @Override
    public void doUpgrade() throws Exception {
        for (Application application : this.applicationManager.findAll()) {
            String errorMessage;
            try {
                log.debug("Updating application {}", (Object)application);
                this.updateApplication(application);
            }
            catch (ApplicationManagerException e) {
                errorMessage = "Could not update application " + application;
                log.error(errorMessage, (Throwable)e);
                this.errors.add(errorMessage + ", error is " + e.getMessage());
            }
            catch (ApplicationNotFoundException e) {
                errorMessage = "Could not find application " + application;
                log.error(errorMessage, (Throwable)e);
                this.errors.add(errorMessage + ", error is " + e.getMessage());
            }
        }
    }

    private void updateApplication(Application application) throws ApplicationManagerException, ApplicationNotFoundException {
        HashSet<RemoteAddress> updatedAddresses = new HashSet<RemoteAddress>();
        Set originalAddresses = application.getRemoteAddresses();
        for (RemoteAddress address : originalAddresses) {
            updatedAddresses.add(new RemoteAddress(address.getAddress()));
        }
        ApplicationImpl applicationImpl = (ApplicationImpl)application;
        applicationImpl.setRemoteAddresses(updatedAddresses);
        this.applicationManager.update((Application)applicationImpl);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }
}

