/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask215
implements UpgradeTask {
    private Collection<String> errors = new ArrayList<String>();
    private DirectoryManager directoryManager;

    @Override
    public String getBuildNumber() {
        return "215";
    }

    @Override
    public String getShortDescription() {
        return "Removing superfluous paged results size attribute(ldap.pagedresults.size) from directories that don't paged results configured.";
    }

    @Override
    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            Boolean usingPagedResults = Boolean.valueOf(directory.getValue("ldap.pagedresults"));
            if (usingPagedResults.booleanValue()) continue;
            DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
            directoryToUpdate.removeAttribute("ldap.pagedresults.size");
            this.directoryManager.updateDirectory((Directory)directoryToUpdate);
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

