/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap.server;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.AuthenticatedToken;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.BulkAddFailedException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPPrincipalWithCredential;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.SearchContext;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.service.soap.ObjectTranslator;
import com.atlassian.crowd.service.soap.SOAPService;
import com.atlassian.crowd.service.soap.server.SecurityServer;
import com.atlassian.crowd.util.SoapExceptionTranslator;
import com.atlassian.crowd.util.SoapObjectTranslator;
import com.google.common.collect.Sets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityServerGeneric
implements SecurityServer {
    private static final Logger logger = Logger.getLogger(SecurityServerGeneric.class);
    private static final String SHOULD_NEVER_REACH_HERE_MSG = "Should never reach here.";
    private final SOAPService soapService;
    private final ApplicationService applicationService;
    private final TokenAuthenticationManager tokenAuthenticationManager;
    private final PropertyManager propertyManager;

    public SecurityServerGeneric(SOAPService soapService, ApplicationService applicationService, PropertyManager propertyManager, TokenAuthenticationManager tokenAuthenticationManager) {
        this.soapService = soapService;
        this.applicationService = applicationService;
        this.propertyManager = propertyManager;
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    public String createPrincipalToken(AuthenticatedToken applicationToken, String username, ValidationFactor[] validationFactors) throws RemoteException, ApplicationAccessDeniedException, InvalidAuthorizationTokenException, com.atlassian.crowd.integration.exception.InactiveAccountException, com.atlassian.crowd.integration.exception.InvalidAuthenticationException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            com.atlassian.crowd.model.authentication.UserAuthenticationContext userAuthenticationContext = new com.atlassian.crowd.model.authentication.UserAuthenticationContext();
            userAuthenticationContext.setApplication(applicationToken.getName());
            PasswordCredential passwordCredential = new PasswordCredential((String)null);
            userAuthenticationContext.setCredential(passwordCredential);
            userAuthenticationContext.setValidationFactors(SoapObjectTranslator.fromSoapValidationFactors((ValidationFactor[])validationFactors));
            userAuthenticationContext.setName(username);
            Token principalToken = this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(userAuthenticationContext);
            return principalToken.getRandomHash();
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            SecurityServerGeneric.throwSoapEquivalentCheckedException(e);
        }
        catch (InactiveAccountException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((InactiveAccountException)e);
        }
        catch (InvalidAuthenticationException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((InvalidAuthenticationException)e);
        }
        catch (ApplicationNotFoundException e) {
            throw new InvalidAuthorizationTokenException((Throwable)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public String authenticatePrincipalSimple(AuthenticatedToken applicationToken, String username, String password) throws RemoteException, com.atlassian.crowd.integration.exception.InvalidAuthenticationException, InvalidAuthorizationTokenException, com.atlassian.crowd.integration.exception.InactiveAccountException, ApplicationAccessDeniedException, com.atlassian.crowd.integration.exception.ExpiredCredentialException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            com.atlassian.crowd.model.authentication.UserAuthenticationContext userAuthenticationContext = new com.atlassian.crowd.model.authentication.UserAuthenticationContext();
            userAuthenticationContext.setApplication(applicationToken.getName());
            PasswordCredential passwordCredential = new PasswordCredential(password);
            userAuthenticationContext.setCredential(passwordCredential);
            userAuthenticationContext.setValidationFactors(new com.atlassian.crowd.model.authentication.ValidationFactor[0]);
            userAuthenticationContext.setName(username);
            Token principalToken = this.tokenAuthenticationManager.authenticateUser(userAuthenticationContext);
            return principalToken.getRandomHash();
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            SecurityServerGeneric.throwSoapEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (InactiveAccountException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((InactiveAccountException)e);
        }
        catch (ExpiredCredentialException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((ExpiredCredentialException)e);
        }
        catch (InvalidAuthenticationException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((InvalidAuthenticationException)e);
        }
        catch (ApplicationNotFoundException e) {
            throw new InvalidAuthorizationTokenException((Throwable)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public AuthenticatedToken authenticateApplication(ApplicationAuthenticationContext authenticationContext) throws RemoteException, com.atlassian.crowd.integration.exception.InvalidAuthenticationException, InvalidAuthorizationTokenException {
        try {
            ValidationFactor[] validationFactors = this.soapService.getApplicationClientValidationFactors(authenticationContext.getName());
            authenticationContext.setValidationFactors(validationFactors);
            Token token = this.tokenAuthenticationManager.authenticateApplication(SoapObjectTranslator.fromSoapApplicationAuthenticationContext((ApplicationAuthenticationContext)authenticationContext));
            AuthenticatedToken applicationToken = new AuthenticatedToken(token.getName(), token.getRandomHash());
            this.soapService.validateSOAPService(applicationToken);
            return applicationToken;
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (InvalidAuthenticationException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((InvalidAuthenticationException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public String authenticatePrincipal(AuthenticatedToken applicationToken, UserAuthenticationContext authenticateContext) throws RemoteException, com.atlassian.crowd.integration.exception.InvalidAuthenticationException, com.atlassian.crowd.integration.exception.InactiveAccountException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException, com.atlassian.crowd.integration.exception.ExpiredCredentialException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            Token principalToken = this.tokenAuthenticationManager.authenticateUser(SoapObjectTranslator.fromSoapUserAuthenticationContext((UserAuthenticationContext)authenticateContext));
            return principalToken.getRandomHash();
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            SecurityServerGeneric.throwSoapEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (InactiveAccountException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((InactiveAccountException)e);
        }
        catch (ExpiredCredentialException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((ExpiredCredentialException)e);
        }
        catch (InvalidAuthenticationException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((InvalidAuthenticationException)e);
        }
        catch (ApplicationNotFoundException e) {
            throw new InvalidAuthorizationTokenException((Throwable)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public boolean isValidPrincipalToken(AuthenticatedToken applicationToken, String principalToken, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            this.tokenAuthenticationManager.validateUserToken(principalToken, SoapObjectTranslator.fromSoapValidationFactors((ValidationFactor[])validationFactors), application.getName());
            return true;
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.exception.InvalidTokenException e) {
            return false;
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            SecurityServerGeneric.throwSoapEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public void invalidatePrincipalToken(AuthenticatedToken applicationToken, String token) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            this.tokenAuthenticationManager.invalidateToken(token);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
    }

    public SOAPGroup[] searchGroups(AuthenticatedToken applicationToken, com.atlassian.crowd.integration.soap.SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            SearchContext.PopulateMemberships population = SearchContext.PopulateMemberships.ALL;
            String groupNameRestriction = null;
            String usernameRestriction = null;
            Boolean activeRestriction = null;
            int maxResults = -1;
            int startIndex = 0;
            if (searchRestrictions != null) {
                for (com.atlassian.crowd.integration.soap.SearchRestriction restriction : searchRestrictions) {
                    if (!StringUtils.isNotBlank((String)restriction.getName()) || !StringUtils.isNotBlank((String)restriction.getValue())) continue;
                    if (restriction.getName().equals("group.populate.direct.sub.groups") || restriction.getName().equals("group.populate.memberships") || restriction.getName().equals("role.populate.memberships")) {
                        population = SearchContext.PopulateMemberships.parseString((String)restriction.getValue());
                        continue;
                    }
                    if (restriction.getName().equals("group.name")) {
                        groupNameRestriction = IdentifierUtils.toLowerCase((String)restriction.getValue());
                        continue;
                    }
                    if (restriction.getName().equals("group.active")) {
                        activeRestriction = Boolean.valueOf(IdentifierUtils.toLowerCase((String)restriction.getValue()));
                        continue;
                    }
                    if (!restriction.getName().equals("group.principal.member")) continue;
                    usernameRestriction = restriction.getValue();
                }
            }
            ArrayList<SOAPGroup> soapGroups = new ArrayList<SOAPGroup>();
            if (usernameRestriction != null) {
                List groups = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(usernameRestriction).startingAt(startIndex).returningAtMost(maxResults));
                for (Group group : groups) {
                    SOAPGroup soapGroup = ObjectTranslator.processGroup(group, Collections.<String>emptyList());
                    soapGroups.add(soapGroup);
                }
            } else {
                GroupQuery query;
                ArrayList<PropertyRestriction> restrictions = new ArrayList<PropertyRestriction>();
                if (groupNameRestriction != null) {
                    restrictions.add(Restriction.on((Property)GroupTermKeys.NAME).containing(groupNameRestriction));
                }
                if (activeRestriction != null) {
                    restrictions.add(Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching(activeRestriction));
                }
                if (restrictions.isEmpty()) {
                    query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, startIndex, maxResults);
                } else {
                    BooleanRestrictionImpl multiRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, (SearchRestriction[])restrictions.toArray(new PropertyRestriction[restrictions.size()]));
                    query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)multiRestriction, startIndex, maxResults);
                }
                List groups = this.applicationService.searchGroups(application, (EntityQuery)query);
                for (Group group : groups) {
                    List members;
                    switch (population) {
                        case NONE: {
                            members = Collections.emptyList();
                            break;
                        }
                        case DIRECT: {
                            members = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(group.getName()).returningAtMost(-1));
                            break;
                        }
                        default: {
                            members = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(group.getName()).returningAtMost(-1));
                        }
                    }
                    SOAPGroup soapGroup = ObjectTranslator.processGroup(group, members);
                    soapGroups.add(soapGroup);
                }
            }
            return ObjectTranslator.processSOAPGroupAndMemberNames(soapGroups.toArray(new SOAPGroup[soapGroups.size()]));
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public SOAPPrincipal[] searchPrincipals(AuthenticatedToken applicationToken, com.atlassian.crowd.integration.soap.SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            UserQuery<User> userQuery = this.buildUserQuery(User.class, searchRestrictions);
            List finalMatchingUsers = this.applicationService.searchUsers(application, userQuery);
            return ObjectTranslator.processUsers(finalMatchingUsers);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    protected <T> UserQuery<T> buildUserQuery(Class<T> returnType, com.atlassian.crowd.integration.soap.SearchRestriction ... searchRestrictions) {
        UserQuery query;
        String nameRestriction = null;
        String emailRestriction = null;
        String fullNameRestriction = null;
        Boolean activeRestriction = null;
        int maxResults = -1;
        int startIndex = 0;
        if (searchRestrictions != null) {
            for (com.atlassian.crowd.integration.soap.SearchRestriction restriction : searchRestrictions) {
                if (!StringUtils.isNotBlank((String)restriction.getName()) || !StringUtils.isNotBlank((String)restriction.getValue())) continue;
                if (restriction.getName().equals("principal.name") || restriction.getName().equals("username")) {
                    nameRestriction = IdentifierUtils.toLowerCase((String)restriction.getValue());
                    continue;
                }
                if (restriction.getName().equals("principal.active")) {
                    activeRestriction = Boolean.valueOf(IdentifierUtils.toLowerCase((String)restriction.getValue()));
                    continue;
                }
                if (restriction.getName().equals("principal.email") || restriction.getName().equals("mail")) {
                    emailRestriction = restriction.getValue().toLowerCase(Locale.ENGLISH);
                    continue;
                }
                if (!restriction.getName().equals("principal.fullname") && !restriction.getName().equals("displayName")) continue;
                fullNameRestriction = IdentifierUtils.toLowerCase((String)restriction.getValue());
            }
        }
        ArrayList<PropertyRestriction> restrictions = new ArrayList<PropertyRestriction>();
        if (nameRestriction != null) {
            restrictions.add(Restriction.on((Property)UserTermKeys.USERNAME).containing(nameRestriction));
        }
        if (activeRestriction != null) {
            restrictions.add(Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching(activeRestriction));
        }
        if (emailRestriction != null) {
            restrictions.add(Restriction.on((Property)UserTermKeys.EMAIL).containing(emailRestriction));
        }
        if (fullNameRestriction != null) {
            restrictions.add(Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing(fullNameRestriction));
        }
        if (restrictions.isEmpty()) {
            query = new UserQuery(returnType, (SearchRestriction)NullRestrictionImpl.INSTANCE, startIndex, maxResults);
        } else {
            BooleanRestrictionImpl multiRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, (SearchRestriction[])restrictions.toArray(new PropertyRestriction[restrictions.size()]));
            query = new UserQuery(returnType, (SearchRestriction)multiRestriction, startIndex, maxResults);
        }
        return query;
    }

    public SOAPRole[] searchRoles(AuthenticatedToken applicationToken, com.atlassian.crowd.integration.soap.SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            GroupQuery query;
            Application application = this.soapService.validateSOAPService(applicationToken);
            SearchContext.PopulateMemberships population = SearchContext.PopulateMemberships.ALL;
            String groupNameRestriction = null;
            Boolean activeRestriction = null;
            int maxResults = -1;
            int startIndex = 0;
            if (searchRestrictions != null) {
                for (com.atlassian.crowd.integration.soap.SearchRestriction restriction : searchRestrictions) {
                    if (!StringUtils.isNotBlank((String)restriction.getName()) || !StringUtils.isNotBlank((String)restriction.getValue())) continue;
                    if (restriction.getName().equals("group.populate.direct.sub.groups") || restriction.getName().equals("group.populate.memberships") || restriction.getName().equals("role.populate.memberships")) {
                        population = SearchContext.PopulateMemberships.parseString((String)restriction.getValue());
                        continue;
                    }
                    if (restriction.getName().equals("role.name")) {
                        groupNameRestriction = IdentifierUtils.toLowerCase((String)restriction.getValue());
                        continue;
                    }
                    if (!restriction.getName().equals("role.active")) continue;
                    activeRestriction = Boolean.valueOf(IdentifierUtils.toLowerCase((String)restriction.getValue()));
                }
            }
            ArrayList<PropertyRestriction> restrictions = new ArrayList<PropertyRestriction>();
            if (groupNameRestriction != null) {
                restrictions.add(Restriction.on((Property)GroupTermKeys.NAME).containing(groupNameRestriction));
            }
            if (activeRestriction != null) {
                restrictions.add(Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching(activeRestriction));
            }
            if (restrictions.isEmpty()) {
                query = new GroupQuery(Group.class, GroupType.LEGACY_ROLE, (SearchRestriction)NullRestrictionImpl.INSTANCE, startIndex, maxResults);
            } else {
                BooleanRestrictionImpl multiRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, (SearchRestriction[])restrictions.toArray(new PropertyRestriction[restrictions.size()]));
                query = new GroupQuery(Group.class, GroupType.LEGACY_ROLE, (SearchRestriction)multiRestriction, startIndex, maxResults);
            }
            List groups = this.applicationService.searchGroups(application, (EntityQuery)query);
            ArrayList<SOAPRole> soapRoles = new ArrayList<SOAPRole>(groups.size());
            for (Group group : groups) {
                List members;
                switch (population) {
                    case NONE: {
                        members = Collections.emptyList();
                        break;
                    }
                    default: {
                        members = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(group.getName()).returningAtMost(-1));
                    }
                }
                SOAPRole soapRole = new SOAPRole(group.getName(), members.toArray(new String[members.size()]));
                soapRoles.add(soapRole);
            }
            return ObjectTranslator.processSOAPRoleAndMemberNames(soapRoles.toArray(new SOAPRole[soapRoles.size()]));
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public SOAPGroup addGroup(AuthenticatedToken applicationToken, SOAPGroup soapGroup) throws RemoteException, InvalidAuthorizationTokenException, com.atlassian.crowd.integration.exception.InvalidGroupException, ApplicationPermissionException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            Group remoteGroup = this.applicationService.addGroup(application, ObjectTranslator.processGroup(soapGroup));
            List nestedMemberNames = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(remoteGroup.getName()).returningAtMost(-1));
            return ObjectTranslator.processGroup(remoteGroup, nestedMemberNames);
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (InvalidGroupException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((InvalidGroupException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public void updateGroup(AuthenticatedToken authenticatedToken, String groupName, String description, boolean active) throws RemoteException, ApplicationPermissionException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(authenticatedToken);
            GroupTemplate groupTemplate = new GroupTemplate(groupName);
            groupTemplate.setActive(active);
            groupTemplate.setDescription(description);
            try {
                this.applicationService.updateGroup(application, groupTemplate);
            }
            catch (InvalidGroupException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (GroupNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public SOAPGroup findGroupByName(AuthenticatedToken applicationToken, String name) throws RemoteException, ObjectNotFoundException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            Group remoteGroup = this.applicationService.findGroupByName(application, name);
            if (remoteGroup.getType() != GroupType.GROUP) {
                throw new GroupNotFoundException(name);
            }
            List nestedMemberNames = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(remoteGroup.getName()).returningAtMost(-1));
            return ObjectTranslator.processGroup(remoteGroup, nestedMemberNames);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public SOAPGroup findGroupWithAttributesByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            GroupWithAttributes remoteGroup = this.applicationService.findGroupWithAttributesByName(application, name);
            if (remoteGroup.getType() != GroupType.GROUP) {
                throw new GroupNotFoundException(name);
            }
            List nestedMemberNames = this.applicationService.searchNestedGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(remoteGroup.getName()).returningAtMost(-1));
            return ObjectTranslator.processGroupWithAttributes(remoteGroup, nestedMemberNames);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public SOAPRole addRole(AuthenticatedToken applicationToken, SOAPRole soapRole) throws RemoteException, InvalidAuthorizationTokenException, InvalidRoleException, ApplicationPermissionException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                Group remoteRole = this.applicationService.addGroup(application, ObjectTranslator.processRole(soapRole));
                List directMemberNames = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(remoteRole.getName()).returningAtMost(-1));
                return ObjectTranslator.processRole(remoteRole, directMemberNames);
            }
            catch (InvalidGroupException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public SOAPRole findRoleByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            Group remoteRole = this.applicationService.findGroupByName(application, name);
            if (remoteRole.getType() != GroupType.LEGACY_ROLE) {
                throw new GroupNotFoundException(name);
            }
            List directMemberNames = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(remoteRole.getName()).returningAtMost(-1));
            return ObjectTranslator.processRole(remoteRole, directMemberNames);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public SOAPPrincipal findPrincipalByToken(AuthenticatedToken applicationToken, String key) throws InvalidAuthorizationTokenException, RemoteException, InvalidTokenException {
        try {
            User user;
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                user = this.tokenAuthenticationManager.findUserByToken(key, application.getName());
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
            return ObjectTranslator.processUser(user);
        }
        catch (com.atlassian.crowd.exception.InvalidTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidTokenException)e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (ApplicationNotFoundException e) {
            throw new InvalidAuthorizationTokenException((Throwable)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public void updatePrincipalAttribute(AuthenticatedToken applicationToken, String name, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            this.storeUserAttribute(application, name, attribute);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (InvalidUserException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void updateGroupAttribute(AuthenticatedToken applicationToken, String group, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            String groupName = this.applicationService.findGroupByName(application, group).getName();
            this.storeCustomGroupAttribute(application, groupName, attribute);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
    }

    public SOAPPrincipal findPrincipalByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            User remotePrincipal = this.applicationService.findUserByName(application, name);
            return ObjectTranslator.processUser(remotePrincipal);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public SOAPPrincipal findPrincipalWithAttributesByName(AuthenticatedToken applicationToken, String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            UserWithAttributes remotePrincipal = this.applicationService.findUserWithAttributesByName(application, name);
            return ObjectTranslator.processUserWithAttributes(remotePrincipal);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public void addAllPrincipals(AuthenticatedToken applicationToken, SOAPPrincipalWithCredential[] principals) throws InvalidAuthorizationTokenException, RemoteException, ApplicationPermissionException, BulkAddFailedException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            ArrayList<UserTemplateWithCredentialAndAttributes> userTemplates = new ArrayList<UserTemplateWithCredentialAndAttributes>();
            for (SOAPPrincipalWithCredential principalWithCredential : principals) {
                SOAPPrincipal principal = principalWithCredential.getPrincipal();
                UserTemplate user = ObjectTranslator.processUser(principal);
                Map<String, Set<String>> attributes = ObjectTranslator.buildUserAttributeMap(principal);
                com.atlassian.crowd.integration.authentication.PasswordCredential credential = principalWithCredential.getPasswordCredential();
                UserTemplateWithCredentialAndAttributes userTemplate = new UserTemplateWithCredentialAndAttributes((User)user, attributes, SoapObjectTranslator.fromSoapPasswordCredential((com.atlassian.crowd.integration.authentication.PasswordCredential)credential));
                userTemplates.add(userTemplate);
            }
            try {
                this.applicationService.addAllUsers(application, userTemplates);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.BulkAddFailedException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.BulkAddFailedException)e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
    }

    public SOAPPrincipal addPrincipal(AuthenticatedToken applicationToken, SOAPPrincipal principal, com.atlassian.crowd.integration.authentication.PasswordCredential credential) throws InvalidAuthorizationTokenException, RemoteException, InvalidCredentialException, ApplicationPermissionException, InvalidUserException {
        try {
            SOAPPrincipal soapPrincipal;
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                User user = this.applicationService.addUser(application, ObjectTranslator.processUser(principal), SoapObjectTranslator.fromSoapPasswordCredential((com.atlassian.crowd.integration.authentication.PasswordCredential)credential));
                soapPrincipal = ObjectTranslator.processUser(user);
                Map<String, Set<String>> attributes = ObjectTranslator.buildUserAttributeMap(principal);
                if (!attributes.isEmpty()) {
                    this.applicationService.storeUserAttributes(application, user.getName(), attributes);
                    UserWithAttributes userWithAttributes = this.applicationService.findUserWithAttributesByName(application, user.getName());
                    soapPrincipal = ObjectTranslator.processUserWithAttributes(userWithAttributes);
                }
            }
            catch (com.atlassian.crowd.exception.InvalidUserException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidUserException)e);
                throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
            catch (UserNotFoundException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
            catch (com.atlassian.crowd.exception.InvalidCredentialException e) {
                SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidCredentialException)e);
                throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
            }
            return soapPrincipal;
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
    }

    public void addPrincipalToGroup(AuthenticatedToken applicationToken, String principal, String group) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                this.applicationService.addUserToGroup(application, principal, group);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
    }

    public void updatePrincipalCredential(AuthenticatedToken applicationToken, String principal, com.atlassian.crowd.integration.authentication.PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                this.applicationService.updateUserCredential(application, principal, SoapObjectTranslator.fromSoapPasswordCredential((com.atlassian.crowd.integration.authentication.PasswordCredential)credential));
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        catch (com.atlassian.crowd.exception.InvalidCredentialException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidCredentialException)e);
        }
    }

    public void resetPrincipalCredential(AuthenticatedToken applicationToken, String principal) throws RemoteException, InvalidEmailAddressException, InvalidAuthorizationTokenException, InvalidCredentialException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                this.applicationService.resetUserCredential(application, principal);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.InvalidEmailAddressException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidEmailAddressException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        catch (com.atlassian.crowd.exception.InvalidCredentialException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidCredentialException)e);
        }
    }

    public void removeGroup(AuthenticatedToken applicationToken, String group) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                this.applicationService.removeGroup(application, group);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
    }

    public void removeRole(AuthenticatedToken applicationToken, String role) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        this.removeGroup(applicationToken, role);
    }

    public void removePrincipal(AuthenticatedToken applicationToken, String principal) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                this.applicationService.removeUser(application, principal);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
    }

    public void addPrincipalToRole(AuthenticatedToken applicationToken, String principal, String role) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        this.addPrincipalToGroup(applicationToken, principal, role);
    }

    public boolean isGroupMember(AuthenticatedToken applicationToken, String group, String principal) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            return this.applicationService.isUserNestedGroupMember(application, principal, group);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public boolean isRoleMember(AuthenticatedToken applicationToken, String role, String principal) throws RemoteException, InvalidAuthorizationTokenException {
        return this.isGroupMember(applicationToken, principal, role);
    }

    public void removePrincipalFromGroup(AuthenticatedToken applicationToken, String principal, String group) throws InvalidAuthorizationTokenException, RemoteException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            try {
                this.applicationService.removeUserFromGroup(application, principal, group);
            }
            catch (OperationFailedException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new RemoteException(e.getMessage(), e);
            }
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
        catch (MembershipNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((MembershipNotFoundException)e);
        }
    }

    public void removePrincipalFromRole(AuthenticatedToken applicationToken, String principal, String role) throws InvalidAuthorizationTokenException, RemoteException, ApplicationPermissionException, ObjectNotFoundException {
        this.removePrincipalFromGroup(applicationToken, principal, role);
    }

    private boolean isPrimaryUserAttribute(String attributeName) {
        return "givenName".equals(attributeName) || "sn".equals(attributeName) || "displayName".equals(attributeName) || "mail".equals(attributeName) || "active".equals(attributeName);
    }

    private void updatePrimaryUserAttribute(Application application, String username, SOAPAttribute attribute) throws RemoteException, ApplicationPermissionException, InvalidUserException, ObjectNotFoundException {
        try {
            String value;
            User user = this.applicationService.findUserByName(application, username);
            UserTemplate userTemplate = new UserTemplate(user);
            if ((attribute.getValues() == null || attribute.getValues().length > 0) && (value = attribute.getValues()[0]) != null) {
                if ("givenName".equals(attribute.getName())) {
                    userTemplate.setFirstName(value);
                } else if ("sn".equals(attribute.getName())) {
                    userTemplate.setLastName(value);
                } else if ("displayName".equals(attribute.getName())) {
                    userTemplate.setDisplayName(value);
                } else if ("mail".equals(attribute.getName())) {
                    userTemplate.setEmailAddress(value);
                } else if ("active".equals(attribute.getName())) {
                    userTemplate.setActive(Boolean.valueOf(value).booleanValue());
                }
                this.applicationService.updateUser(application, userTemplate);
            }
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        catch (com.atlassian.crowd.exception.InvalidUserException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidUserException)e);
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private void storeCustomUserAttribute(Application application, String username, SOAPAttribute attribute) throws RemoteException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            HashMap<String, HashSet> attribs = new HashMap<String, HashSet>();
            attribs.put(attribute.getName(), Sets.newHashSet((Object[])attribute.getValues()));
            this.applicationService.storeUserAttributes(application, username, attribs);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private void storeCustomGroupAttribute(Application application, String group, SOAPAttribute attribute) throws RemoteException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            HashMap<String, HashSet> attribs = new HashMap<String, HashSet>();
            attribs.put(attribute.getName(), Sets.newHashSet((Object[])attribute.getValues()));
            this.applicationService.storeGroupAttributes(application, group, attribs);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private void storeUserAttribute(Application application, String username, SOAPAttribute attribute) throws RemoteException, ApplicationPermissionException, InvalidUserException, ObjectNotFoundException {
        if (this.isPrimaryUserAttribute(attribute.getName())) {
            this.updatePrimaryUserAttribute(application, username, attribute);
        } else {
            this.storeCustomUserAttribute(application, username, attribute);
        }
    }

    private void removeUserAttribute(Application application, String username, String attributeName) throws RemoteException, ApplicationPermissionException, ObjectNotFoundException {
        if (this.isPrimaryUserAttribute(attributeName)) {
            throw new RemoteException("Cannot remove the attribute <" + attributeName + "> as it is a primary attribute");
        }
        try {
            this.applicationService.removeUserAttributes(application, username, attributeName);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (UserNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((UserNotFoundException)e);
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private void removeGroupAttribute(Application application, String groupName, String attributeName) throws RemoteException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            this.applicationService.removeGroupAttributes(application, groupName, attributeName);
        }
        catch (com.atlassian.crowd.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.ApplicationPermissionException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
        catch (OperationFailedException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void addAttributeToPrincipal(AuthenticatedToken applicationToken, String principal, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        this.updatePrincipalAttribute(applicationToken, principal, attribute);
    }

    public void addAttributeToGroup(AuthenticatedToken applicationToken, String group, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        this.updateGroupAttribute(applicationToken, group, attribute);
    }

    public void removeAttributeFromPrincipal(AuthenticatedToken applicationToken, String principal, String attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            this.removeUserAttribute(application, principal, attribute);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
    }

    public void removeAttributeFromGroup(AuthenticatedToken applicationToken, String group, String attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            String groupName = this.applicationService.findGroupByName(application, group).getName();
            this.removeGroupAttribute(application, groupName, attribute);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
        }
        catch (GroupNotFoundException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((GroupNotFoundException)e);
        }
    }

    public long getCacheTime(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            return this.propertyManager.getCacheTime();
        }
        catch (PropertyManagerException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public boolean isCacheEnabled(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            return this.propertyManager.isCacheEnabled();
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public String getDomain(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            return this.propertyManager.getDomain();
        }
        catch (PropertyManagerException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public String[] findAllPrincipalNames(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            List usernames = this.applicationService.searchUsers(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
            return usernames.toArray(new String[usernames.size()]);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public String[] findAllGroupNames(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            List groupNames = this.applicationService.searchGroups(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
            return groupNames.toArray(new String[groupNames.size()]);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public SOAPNestableGroup[] findAllGroupRelationships(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            List groups = this.applicationService.searchGroups(application, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
            ArrayList<SOAPNestableGroup> soapNestableGroups = new ArrayList<SOAPNestableGroup>();
            for (Group group : groups) {
                List childGroups = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(group.getName()).returningAtMost(-1));
                SOAPNestableGroup nestableGroup = ObjectTranslator.processNestableGroup(group, childGroups);
                soapNestableGroups.add(nestableGroup);
            }
            return ObjectTranslator.processSOAPNestableGroupAndMemberNames(soapNestableGroups);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public String[] findAllRoleNames(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        return this.findAllGroupNames(applicationToken);
    }

    public String[] findGroupMemberships(AuthenticatedToken applicationToken, String principalName) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            List memberships = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).parentsOf(EntityDescriptor.user()).withName(principalName).returningAtMost(-1));
            return memberships.toArray(new String[memberships.size()]);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public String[] findRoleMemberships(AuthenticatedToken applicationToken, String principalName) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            List memberships = this.applicationService.searchDirectGroupRelationships(application, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.user()).withName(principalName).returningAtMost(-1));
            return memberships.toArray(new String[memberships.size()]);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public String[] getGrantedAuthorities(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            Application application = this.soapService.validateSOAPService(applicationToken);
            HashSet<String> groupNames = new HashSet<String>();
            for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
                for (GroupMapping groupMapping : directoryMapping.getAuthorisedGroups()) {
                    groupNames.add(groupMapping.getGroupName());
                }
            }
            return groupNames.toArray(new String[groupNames.size()]);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    public SOAPCookieInfo getCookieInfo(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            this.soapService.validateSOAPService(applicationToken);
            SOAPCookieInfo cookieInfo = new SOAPCookieInfo();
            cookieInfo.setDomain(this.propertyManager.getDomain());
            cookieInfo.setSecure(this.propertyManager.isSecureCookie());
            return cookieInfo;
        }
        catch (PropertyManagerException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.atlassian.crowd.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwSoapEquivalentCheckedException((com.atlassian.crowd.exception.InvalidAuthorizationTokenException)e);
            throw new AssertionError((Object)SHOULD_NEVER_REACH_HERE_MSG);
        }
    }

    private static void throwSoapEquivalentCheckedException(com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) throws ApplicationAccessDeniedException {
        throw new ApplicationAccessDeniedException(e.getMessage(), e.getCause());
    }
}

