/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.factory;

import com.atlassian.crowd.plugin.PluginDirectoryLocator;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundledPluginLoaderFactory
implements FactoryBean {
    private static final Logger log = Logger.getLogger(BundledPluginLoaderFactory.class);
    private final PluginDirectoryLocator pluginDirectoryLocator;
    private final List<PluginFactory> pluginFactories;
    private final PluginEventManager pluginEventManager;
    private final String bundledPluginFileName;
    private static final String ATLASSIAN_PLUGINS_BUNDLED_DISABLE = "atlassian.plugins.bundled.disable";

    public BundledPluginLoaderFactory(PluginDirectoryLocator pluginDirectoryLocator, List<PluginFactory> pluginFactories, PluginEventManager pluginEventManager, String bundledPluginFileName) {
        this.pluginDirectoryLocator = pluginDirectoryLocator;
        this.pluginFactories = pluginFactories;
        this.pluginEventManager = pluginEventManager;
        this.bundledPluginFileName = bundledPluginFileName;
    }

    public Object getObject() throws Exception {
        if (!Boolean.getBoolean(ATLASSIAN_PLUGINS_BUNDLED_DISABLE)) {
            File frameworkBundlesDirectory = this.pluginDirectoryLocator.getBundledPluginsDirectory();
            URL bundledPluginsURL = null;
            if (Boolean.getBoolean("atlassian.dev.mode")) {
                String bundledPluginFile = StringUtils.replaceOnce((String)this.bundledPluginFileName, (String)".", (String)"-dev.");
                bundledPluginsURL = ClassLoaderUtils.getResource((String)bundledPluginFile, this.getClass());
                log.warn((Object)("We are in dev mode, using the following location for plugins <" + bundledPluginsURL.toExternalForm() + ">"));
            } else {
                bundledPluginsURL = ClassLoaderUtils.getResource((String)this.bundledPluginFileName, this.getClass());
            }
            if (bundledPluginsURL == null) {
                throw new IllegalStateException("Could not load <" + this.bundledPluginFileName + "> from classpath");
            }
            return new BundledPluginLoader(bundledPluginsURL, frameworkBundlesDirectory, this.pluginFactories, this.pluginEventManager);
        }
        log.warn((Object)"Bundled plugins have been disabled. Removing bundled plugin loader.");
        return null;
    }

    public Class getObjectType() {
        return BundledPluginLoader.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

