/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.database.DatabaseImporter;
import com.atlassian.crowd.migration.legacy.database.DatabaseMapper;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMapper
extends DatabaseMapper
implements DatabaseImporter {
    private final GroupDAOHibernate groupDAO;
    private final MembershipDAOHibernate membershipDAO;
    private final DirectoryDAOHibernate directoryDAO;

    public GroupMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, JdbcOperations jdbcTemplate, GroupDAOHibernate groupDAO, MembershipDAOHibernate membershipDAO, DirectoryDAOHibernate directoryDAO) {
        super(sessionFactory, batchProcessor, jdbcTemplate);
        this.groupDAO = groupDAO;
        this.membershipDAO = membershipDAO;
        this.directoryDAO = directoryDAO;
    }

    @Override
    public void importFromDatabase(LegacyImportDataHolder importData) throws ImportException {
        List<InternalGroupWithAttributes> groups = this.importGroupsFromDatabase(importData.getOldToNewDirectoryIds());
        BatchResultWithIdReferences groupImportResults = this.groupDAO.addAll(groups);
        for (Group group : groupImportResults.getFailedEntities()) {
            this.logger.error((Object)("Unable to add group <" + group.getName() + "> in directory with id <" + group.getDirectoryId() + ">"));
        }
        if (groupImportResults.hasFailures()) {
            throw new ImportException("Unable to import all groups. See logs for more details.");
        }
        Set<InternalMembership> memberships = this.importMembershipsFromDatabase(importData, (BatchResultWithIdReferences<Group>)groupImportResults);
        BatchResult membershipResult = this.membershipDAO.addAll(memberships);
        for (InternalMembership membership : membershipResult.getFailedEntities()) {
            this.logger.error((Object)("Unable to add user <" + membership.getChildName() + "> to group <" + membership.getParentName() + "> in directory with id <" + membership.getDirectory().getId() + ">"));
        }
        if (membershipResult.hasFailures()) {
            throw new ImportException("Unable to import all memberships. See logs for more details.");
        }
        this.logger.info((Object)("Successfully migrated " + groupImportResults.getTotalSuccessful() + " groups, with " + memberships.size() + " memberships."));
    }

    protected List<InternalGroupWithAttributes> importGroupsFromDatabase(Map<Long, Long> oldToNewDirectoryIds) {
        ArrayList<InternalGroupWithAttributes> internalGroupWithAttributes = new ArrayList<InternalGroupWithAttributes>();
        GroupTableMapper groupTableMapper = new GroupTableMapper(oldToNewDirectoryIds);
        Map<InternalGroup, Long> groupToOldDirectoryId = groupTableMapper.getGroupToOldDirectoryIds();
        List<InternalGroup> groups = this.getGroups(groupTableMapper);
        Map<DatabaseMapper.EntityIdentifier, Map<String, Set<String>>> allGroupAttributes = this.getGroupAttributes();
        for (InternalGroup group : groups) {
            DatabaseMapper.EntityIdentifier currentGroup = new DatabaseMapper.EntityIdentifier(this, groupToOldDirectoryId.get(group), group.getName());
            Map<String, Set<String>> attributes = allGroupAttributes.get(currentGroup);
            if (attributes == null) {
                attributes = new HashMap<String, Set<String>>();
            }
            internalGroupWithAttributes.add(new InternalGroupWithAttributes(group, attributes));
        }
        return internalGroupWithAttributes;
    }

    private List<InternalGroup> getGroups(GroupTableMapper groupTableMapper) {
        return this.jdbcTemplate.query(this.legacyTableQueries.getGroupsSQL(), (RowMapper)groupTableMapper);
    }

    private Map<DatabaseMapper.EntityIdentifier, Map<String, Set<String>>> getGroupAttributes() {
        DatabaseMapper.AttributeMapper groupAttributeMapper = new DatabaseMapper.AttributeMapper(this, "REMOTEGROUPDIRECTORYID", "REMOTEGROUPNAME");
        this.jdbcTemplate.query(this.legacyTableQueries.getGroupAttributesSQL(), (RowCallbackHandler)groupAttributeMapper);
        groupAttributeMapper.getEntityAttributes();
        Map<DatabaseMapper.EntityIdentifier, List<Map<String, String>>> groupAttributes = groupAttributeMapper.getEntityAttributes();
        HashMap<DatabaseMapper.EntityIdentifier, Map<String, Set<String>>> groupAttributeMap = new HashMap<DatabaseMapper.EntityIdentifier, Map<String, Set<String>>>();
        for (Map.Entry<DatabaseMapper.EntityIdentifier, List<Map<String, String>>> entry : groupAttributes.entrySet()) {
            groupAttributeMap.put(entry.getKey(), this.attributeListToMultiAttributeMap(entry.getValue()));
        }
        return groupAttributeMap;
    }

    protected Set<InternalMembership> importMembershipsFromDatabase(LegacyImportDataHolder importData, BatchResultWithIdReferences<Group> groupImportResults) {
        MembershipTableMapper membershipTableMapper = new MembershipTableMapper(importData, groupImportResults);
        List memberships = this.jdbcTemplate.query(this.legacyTableQueries.getGroupMembershipsSQL(), (RowMapper)membershipTableMapper);
        return new HashSet<InternalMembership>(memberships);
    }

    private class MembershipTableMapper
    implements RowMapper {
        private final LegacyImportDataHolder importData;
        private final BatchResultWithIdReferences groupImportResults;

        public MembershipTableMapper(LegacyImportDataHolder importData, BatchResultWithIdReferences groupImportResults) {
            this.importData = importData;
            this.groupImportResults = groupImportResults;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            String parentName = rs.getString("REMOTEGROUPNAME");
            String childName = rs.getString("REMOTEPRINCIPALNAME");
            Long oldDirectoryId = rs.getLong("REMOTEGROUPDIRECTORYID");
            Long directoryId = this.importData.getOldToNewDirectoryIds().get(oldDirectoryId);
            if (directoryId == null) {
                throw new IllegalArgumentException("Group belongs to an unknown old directory with ID: " + directoryId);
            }
            DirectoryImpl directory = (DirectoryImpl)GroupMapper.this.directoryDAO.loadReference(directoryId.longValue());
            Long groupId = this.groupImportResults.getIdReference(directoryId, parentName);
            Long userId = this.importData.getUserImportResults().getIdReference(directoryId, childName);
            return new InternalMembership(null, groupId, userId, MembershipType.GROUP_USER, GroupType.GROUP, parentName, childName, directory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupTableMapper
    implements RowMapper {
        private final Map<Long, Long> oldToNewDirectoryIds;
        private final Map<InternalGroup, Long> groupToOldDirectoryIds = new HashMap<InternalGroup, Long>();

        public GroupTableMapper(Map<Long, Long> oldToNewDirectoryIds) {
            this.oldToNewDirectoryIds = oldToNewDirectoryIds;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long oldDirectoryId = rs.getLong("DIRECTORYID");
            String groupName = rs.getString("NAME");
            boolean active = rs.getBoolean("ACTIVE");
            Date createDate = GroupMapper.this.getDateFromDatabase(rs.getString("CONCEPTION"));
            Date updatedDate = GroupMapper.this.getDateFromDatabase(rs.getString("LASTMODIFIED"));
            String description = rs.getString("DESCRIPTION");
            GroupType groupType = GroupType.GROUP;
            Long directoryId = this.oldToNewDirectoryIds.get(oldDirectoryId);
            if (directoryId == null) {
                throw new IllegalArgumentException("Group belongs to an unknown old directory with ID: " + directoryId);
            }
            Directory directory = (Directory)GroupMapper.this.directoryDAO.loadReference(directoryId.longValue());
            InternalEntityTemplate internalEntityTemplate = GroupMapper.this.createInternalEntityTemplate(directoryId, groupName, createDate, updatedDate, active);
            internalEntityTemplate.setId(null);
            GroupTemplate groupTemplate = new GroupTemplate(internalEntityTemplate.getName(), directoryId.longValue(), groupType);
            groupTemplate.setActive(internalEntityTemplate.isActive());
            groupTemplate.setDescription(description);
            InternalGroup group = new InternalGroup(internalEntityTemplate, directory, groupTemplate);
            this.groupToOldDirectoryIds.put(group, oldDirectoryId);
            return group;
        }

        public Map<InternalGroup, Long> getGroupToOldDirectoryIds() {
            return this.groupToOldDirectoryIds;
        }
    }
}

