/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate3.operation.ReplicateOperation;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericMapper {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected static final String XML_DATE_FORMAT = "EEE MMM dd HH:mm:ss Z yyyy";
    protected static final String DATABASE_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static final String PLUGIN_KEY_PREFIX = "plugin.";
    private final SessionFactory sessionFactory;
    private final BatchProcessor batchProcessor;

    public GenericMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor) {
        this.sessionFactory = sessionFactory;
        this.batchProcessor = batchProcessor;
    }

    public String getDateAsFormattedString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(XML_DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    public Date getDateFromXml(String dateString) {
        return this.getDateFromFormattedString(dateString, XML_DATE_FORMAT);
    }

    public Date getDateFromDatabase(String dateString) {
        return this.getDateFromFormattedString(dateString, DATABASE_DATE_FORMAT);
    }

    private Date getDateFromFormattedString(String dateString, String dateFormat) {
        Date date = null;
        if (StringUtils.isNotBlank((String)dateString)) {
            try {
                date = new SimpleDateFormat(dateFormat).parse(dateString);
            }
            catch (ParseException e) {
                this.logger.error((Object)("Failed to parse date: " + dateString), (Throwable)e);
            }
        }
        return date;
    }

    protected void addEntity(Object entityToPersist) throws ImportException {
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            if (session.isDirty()) {
                session.flush();
                session.connection().commit();
                session.clear();
            }
            session.replicate(entityToPersist, ReplicationMode.OVERWRITE);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException e) {
            throw new ImportException(e);
        }
    }

    protected <T extends Serializable> void addEntities(List<T> entitiesToPersist) throws HibernateException {
        BatchResult result = this.batchProcessor.execute((HibernateOperation)new ReplicateOperation(ReplicationMode.OVERWRITE), entitiesToPersist);
        if (result.hasFailures()) {
            for (Serializable entity : result.getFailedEntities()) {
                this.logger.error((Object)("Could not add " + entity.toString()));
            }
            throw new HibernateException("Could not replicate the entire batch using the BatchProcessor.");
        }
    }

    protected Object addEntityViaMerge(Object entityToPersist) throws ImportException {
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            if (session.isDirty()) {
                session.flush();
                session.connection().commit();
                session.clear();
            }
            session.merge(entityToPersist);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException e) {
            throw new ImportException(e);
        }
        return entityToPersist;
    }

    protected Object addEntityViaSave(Object entityToPersist) throws ImportException {
        try {
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            if (session.isDirty()) {
                session.flush();
                session.connection().commit();
                session.clear();
            }
            session.save(entityToPersist);
            session.flush();
            session.connection().commit();
        }
        catch (SQLException e) {
            throw new ImportException(e);
        }
        return entityToPersist;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected OperationType getOperationTypeFromLegacyPermissionName(String name) {
        if (name.equals("principal.add")) {
            return OperationType.CREATE_USER;
        }
        if (name.equals("group.add")) {
            return OperationType.CREATE_GROUP;
        }
        if (name.equals("role.add")) {
            return OperationType.CREATE_ROLE;
        }
        if (name.equals("principal.modify")) {
            return OperationType.UPDATE_USER;
        }
        if (name.equals("group.modify")) {
            return OperationType.UPDATE_GROUP;
        }
        if (name.equals("role.modify")) {
            return OperationType.UPDATE_ROLE;
        }
        if (name.equals("principal.remove")) {
            return OperationType.DELETE_USER;
        }
        if (name.equals("group.remove")) {
            return OperationType.DELETE_GROUP;
        }
        if (name.equals("role.remove")) {
            return OperationType.DELETE_ROLE;
        }
        return null;
    }

    protected String getAttributeValue(String name, Map<String, Set<String>> attributes, String defaultValue) {
        Set<String> values = attributes.get(name);
        if (values != null && !values.isEmpty()) {
            return values.iterator().next();
        }
        return defaultValue;
    }

    protected DirectoryType getDirectoryTypeFromLegacyCode(int code) {
        switch (code) {
            case 0: {
                return DirectoryType.UNKNOWN;
            }
            case 1: {
                return DirectoryType.INTERNAL;
            }
            case 2: {
                return DirectoryType.CONNECTOR;
            }
            case 3: {
                return DirectoryType.CUSTOM;
            }
            case 4: {
                return DirectoryType.DELEGATING;
            }
        }
        throw new IllegalArgumentException("Code is not valid");
    }

    protected String getNameFromLegacyCode(String codeName) {
        int code = Integer.parseInt(codeName);
        switch (code) {
            case 1: {
                return "cache.time";
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
            case 4: {
                return "token.seed";
            }
            case 5: {
                return null;
            }
            case 6: {
                return "deployment.title";
            }
            case 7: {
                return "domain";
            }
            case 8: {
                return "cache.enabled";
            }
            case 9: {
                return "session.time";
            }
            case 10: {
                return null;
            }
            case 11: {
                return "mailserver.host";
            }
            case 12: {
                return "mailserver.prefix";
            }
            case 13: {
                return "mailserver.sender";
            }
            case 14: {
                return "mailserver.username";
            }
            case 15: {
                return "mailserver.password";
            }
            case 16: {
                return "des.encryption.key";
            }
            case 17: {
                return "mailserver.message.template";
            }
            case 18: {
                return null;
            }
            case 19: {
                return null;
            }
            case 20: {
                return "current.license.resource.total";
            }
            case 21: {
                return "notification.email";
            }
            case 22: {
                return null;
            }
            case 23: {
                return "build.number";
            }
            case 24: {
                return "gzip.enabled";
            }
            case 25: {
                return "trusted.proxy.servers";
            }
            case 26: {
                return "database.token.storage.enabled";
            }
            case 27: {
                return "mailserver.jndi";
            }
            case 28: {
                return "mailserver.port";
            }
            case 29: {
                return "secure.cookie";
            }
        }
        return null;
    }
}

