/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.proxy;

import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.util.RemoteAddressHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedProxyManagerImpl
implements TrustedProxyManager {
    private static final Logger logger = LoggerFactory.getLogger(TrustedProxyManagerImpl.class);
    private final PropertyManager propertyManager;
    private final CacheManager cacheManager;
    private static final char DELIMITER = ',';
    protected static final String REQUESTED_PROXIES_CACHE = TrustedProxyManagerImpl.class.getName() + "_requested_proxies";

    public TrustedProxyManagerImpl(PropertyManager propertyManager, CacheManager cacheManager) {
        this.propertyManager = propertyManager;
        this.cacheManager = cacheManager;
    }

    public boolean isTrusted(String remoteAddress) {
        try {
            return (Boolean)this.cacheManager.get(REQUESTED_PROXIES_CACHE, (Serializable)((Object)remoteAddress));
        }
        catch (NotInCacheException e) {
            RemoteAddress requestProxyAddress = new RemoteAddress(remoteAddress);
            boolean trusted = false;
            for (RemoteAddress trustedProxy : this.getTrustedProxies()) {
                if (!RemoteAddressHelper.isAddressAllowed((RemoteAddress)trustedProxy, (RemoteAddress)requestProxyAddress)) continue;
                trusted = true;
                break;
            }
            this.cacheManager.put(REQUESTED_PROXIES_CACHE, (Serializable)((Object)remoteAddress), (Serializable)Boolean.valueOf(trusted));
            return trusted;
        }
    }

    public Set<String> getAddresses() {
        return this.getAddressesFromPropertyManager();
    }

    public boolean addAddress(String remoteAddress) {
        boolean addressesModified;
        if (StringUtils.isBlank((String)remoteAddress)) {
            return false;
        }
        Set<String> currentAddresses = this.getAddressesFromPropertyManager();
        int originalNumAddresses = currentAddresses.size();
        HashSet newAddresses = Sets.newHashSet(currentAddresses);
        for (String address : StringUtils.split((String)remoteAddress, (char)',')) {
            if (StringUtils.isBlank((String)address)) continue;
            newAddresses.add(address.trim());
        }
        boolean bl = addressesModified = originalNumAddresses != newAddresses.size();
        if (addressesModified) {
            return this.saveAddresses((Collection<String>)ImmutableSet.copyOf((Iterable)newAddresses));
        }
        return false;
    }

    public void removeAddress(String remoteAddress) {
        Set<String> trustedProxies = this.getAddressesFromPropertyManager();
        if (trustedProxies.contains(remoteAddress)) {
            ImmutableSet newTrustedProxies = ImmutableSet.copyOf((Iterable)Sets.difference(trustedProxies, Collections.singleton(remoteAddress)));
            this.saveAddresses((Collection<String>)newTrustedProxies);
        }
    }

    private Set<String> getAddressesFromPropertyManager() {
        try {
            String proxies = this.propertyManager.getTrustedProxyServers();
            if (!StringUtils.isBlank((String)proxies)) {
                Object[] proxyStrings = StringUtils.split((String)proxies, (char)',');
                return ImmutableSet.of((Object[])proxyStrings);
            }
        }
        catch (PropertyManagerException e) {
            logger.debug("No proxies loaded", (Throwable)e);
        }
        return Collections.emptySet();
    }

    private boolean setProperty(String value) {
        try {
            this.propertyManager.setTrustedProxyServers(value);
            return true;
        }
        catch (RuntimeException e) {
            logger.warn("Unable to save list of trusted proxy servers", (Throwable)e);
            return false;
        }
    }

    private Set<RemoteAddress> getTrustedProxies() {
        Set<String> proxies = this.getAddressesFromPropertyManager();
        ImmutableSet.Builder proxyListBuilder = ImmutableSet.builder();
        for (String proxy : proxies) {
            proxyListBuilder.add((Object)new RemoteAddress(proxy));
        }
        return proxyListBuilder.build();
    }

    private boolean saveAddresses(Collection<String> trustedProxies) {
        String proxies = StringUtils.join(trustedProxies, (char)',');
        boolean propertySet = this.setProperty(proxies);
        this.cacheManager.removeAll(REQUESTED_PROXIES_CACHE);
        return propertySet;
    }
}

