/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.model;

public final class MembershipDTO {
    private String childName;
    private ChildType childType;
    private String parentName;

    public MembershipDTO(ChildType childType, String childName, String parentName) {
        this.childType = childType;
        this.childName = childName;
        this.parentName = parentName;
    }

    public String getChildName() {
        return this.childName;
    }

    public void setChildName(String username) {
        this.childName = username;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public ChildType getChildType() {
        return this.childType;
    }

    public void setChildType(ChildType childType) {
        this.childType = childType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MembershipDTO that = (MembershipDTO)o;
        if (this.childName != null ? !this.childName.equals(that.childName) : that.childName != null) {
            return false;
        }
        if (this.childType != that.childType) {
            return false;
        }
        return !(this.parentName != null ? !this.parentName.equals(that.parentName) : that.parentName != null);
    }

    public int hashCode() {
        int result = this.childName != null ? this.childName.hashCode() : 0;
        result = 31 * result + (this.childType != null ? this.childType.hashCode() : 0);
        result = 31 * result + (this.parentName != null ? this.parentName.hashCode() : 0);
        return result;
    }

    public String getRelationship() {
        return MembershipDTO.getRelationshipKey(this.childType, this.childName, this.parentName);
    }

    public static String getRelationshipKey(ChildType childType, String childName, String containerName) {
        return childName + "(" + (Object)((Object)childType) + ") - " + containerName;
    }

    public String toString() {
        return MembershipDTO.getRelationshipKey(this.childType, this.childName, this.parentName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChildType {
        USER,
        GROUP;

    }
}

