/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.config.DirectoryConfiguration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.BaseImporter;
import com.atlassian.crowd.importer.model.MembershipDTO;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.util.PasswordHelper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryImporter
extends BaseImporter {
    private PasswordHelper passwordHelper;

    public DirectoryImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager);
        this.passwordHelper = passwordHelper;
    }

    @Override
    public Collection<MembershipDTO> findUserToGroupMemberships(Configuration configuration) throws ImporterException {
        DirectoryConfiguration directoryConfiguration = (DirectoryConfiguration)configuration;
        Collection<GroupTemplate> groups = this.findGroups(configuration);
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        try {
            for (GroupTemplate group : groups) {
                List members = this.directoryManager.searchDirectGroupRelationships(directoryConfiguration.getSourceDirectoryID().longValue(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1));
                setBuilder.addAll((Iterable)Collections2.transform((Collection)members, (Function)new MemberToMembershipMapper(group.getName(), MembershipDTO.ChildType.USER)));
            }
        }
        catch (Exception e) {
            throw new ImporterException(e);
        }
        return setBuilder.build();
    }

    @Override
    public Collection<MembershipDTO> findGroupToGroupMemberships(Configuration configuration) throws ImporterException {
        if (!configuration.getImportNestedGroups().booleanValue()) {
            throw new IllegalStateException("findGroupToGroupMemberships cannot be called given nested group is not supported");
        }
        DirectoryConfiguration directoryConfiguration = (DirectoryConfiguration)configuration;
        Collection<GroupTemplate> groups = this.findGroups(configuration);
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        try {
            for (GroupTemplate group : groups) {
                List members = this.directoryManager.searchDirectGroupRelationships(directoryConfiguration.getSourceDirectoryID().longValue(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1));
                setBuilder.addAll((Iterable)Collections2.transform((Collection)members, (Function)new MemberToMembershipMapper(group.getName(), MembershipDTO.ChildType.GROUP)));
            }
        }
        catch (Exception e) {
            throw new ImporterException(e);
        }
        return setBuilder.build();
    }

    @Override
    public Collection<GroupTemplate> findGroups(Configuration configuration) throws ImporterException {
        DirectoryConfiguration directoryConfiguration = (DirectoryConfiguration)configuration;
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        try {
            List groups = this.directoryManager.searchGroups(directoryConfiguration.getSourceDirectoryID().longValue(), QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
            for (Group group : groups) {
                GroupTemplate groupTemplate = new GroupTemplate(group);
                setBuilder.add((Object)groupTemplate);
            }
        }
        catch (Exception e) {
            throw new ImporterException(e);
        }
        return setBuilder.build();
    }

    @Override
    public Collection<UserTemplateWithCredentialAndAttributes> findUsers(Configuration configuration) throws ImporterException {
        DirectoryConfiguration directoryConfiguration = (DirectoryConfiguration)configuration;
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        try {
            List users = this.directoryManager.searchUsers(directoryConfiguration.getSourceDirectoryID().longValue(), QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
            for (User user : users) {
                PasswordCredential credential = user instanceof InternalUser ? ((InternalUser)user).getCredential() : new PasswordCredential(this.passwordHelper.generateRandomPassword(), false);
                setBuilder.add((Object)new UserTemplateWithCredentialAndAttributes(user, credential));
            }
        }
        catch (Exception e) {
            throw new ImporterException(e);
        }
        return setBuilder.build();
    }

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public Class getConfigurationType() {
        return DirectoryConfiguration.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemberToMembershipMapper
    implements Function<String, MembershipDTO> {
        private final String parent;
        private final MembershipDTO.ChildType childType;

        MemberToMembershipMapper(String parent, MembershipDTO.ChildType childType) {
            this.parent = parent;
            this.childType = childType;
        }

        public MembershipDTO apply(String member) {
            return new MembershipDTO(this.childType, member, this.parent);
        }
    }
}

