/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.config.CsvConfiguration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.BaseImporter;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.mappers.csv.GroupMapper;
import com.atlassian.crowd.importer.mappers.csv.MembershipMapper;
import com.atlassian.crowd.importer.mappers.csv.UserMapper;
import com.atlassian.crowd.importer.model.MembershipDTO;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.PasswordHelper;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImporter
extends BaseImporter
implements Importer {
    private PasswordHelper passwordHelper;
    private static final Logger logger = Logger.getLogger(CsvImporter.class);

    public CsvImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager);
        this.passwordHelper = passwordHelper;
    }

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public Class getConfigurationType() {
        return CsvConfiguration.class;
    }

    @Override
    public Collection<MembershipDTO> findUserToGroupMemberships(Configuration configuration) {
        CsvConfiguration csvconfiguration = (CsvConfiguration)configuration;
        ArrayList<MembershipDTO> memberships = new ArrayList<MembershipDTO>();
        if (csvconfiguration.getGroupMemberships() == null) {
            return Collections.emptyList();
        }
        OrderedBidiMap groupMapping = csvconfiguration.getGroupMappingConfiguration();
        try {
            CSVStrategy strategy = CSVStrategy.EXCEL_STRATEGY;
            strategy.setDelimiter(csvconfiguration.getDelimiter().charValue());
            CSVParser csvParser = new CSVParser((Reader)new FileReader(csvconfiguration.getGroupMemberships()), strategy);
            MembershipMapper membershipMapper = new MembershipMapper(csvconfiguration.getDirectoryID(), groupMapping);
            csvParser.getLine();
            String[] membershipLine = csvParser.getLine();
            while (membershipLine != null) {
                MembershipDTO membership = membershipMapper.mapRow(membershipLine);
                memberships.add(membership);
                membershipLine = csvParser.getLine();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return memberships;
    }

    @Override
    public Collection<MembershipDTO> findGroupToGroupMemberships(Configuration configuration) throws ImporterException {
        throw new UnsupportedOperationException("Nested group not supported yet for CSV imports");
    }

    @Override
    public Collection<GroupTemplate> findGroups(Configuration configuration) {
        CsvConfiguration csvconfiguration = (CsvConfiguration)configuration;
        HashSet<GroupTemplate> groups = new HashSet<GroupTemplate>();
        OrderedBidiMap groupMapping = csvconfiguration.getGroupMappingConfiguration();
        if (groupMapping == null || csvconfiguration.getGroupMemberships() == null) {
            return Collections.emptyList();
        }
        try {
            CSVStrategy strategy = CSVStrategy.EXCEL_STRATEGY;
            strategy.setDelimiter(csvconfiguration.getDelimiter().charValue());
            CSVParser csvParser = new CSVParser((Reader)new FileReader(csvconfiguration.getGroupMemberships()), strategy);
            GroupMapper groupMapper = new GroupMapper(csvconfiguration.getDirectoryID(), groupMapping);
            csvParser.getLine();
            String[] membershipLine = null;
            do {
                try {
                    membershipLine = csvParser.getLine();
                    GroupTemplate group = groupMapper.mapRow(membershipLine);
                    if (group == null) continue;
                    groups.add(group);
                }
                catch (IOException ioe) {
                    logger.error((Object)("Failed to parse line, due too: " + ioe.getMessage()));
                }
            } while (membershipLine != null);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    @Override
    public Collection<UserTemplateWithCredentialAndAttributes> findUsers(Configuration configuration) {
        CsvConfiguration csvconfiguration = (CsvConfiguration)configuration;
        if (csvconfiguration.getUserMappingConfiguration() == null || csvconfiguration.getUsers() == null) {
            return Collections.emptyList();
        }
        ArrayList<UserTemplateWithCredentialAndAttributes> users = new ArrayList<UserTemplateWithCredentialAndAttributes>();
        OrderedBidiMap userMapping = csvconfiguration.getUserMappingConfiguration();
        try {
            CSVStrategy strategy = CSVStrategy.EXCEL_STRATEGY;
            strategy.setDelimiter(csvconfiguration.getDelimiter().charValue());
            CSVParser csvParser = new CSVParser((Reader)new FileReader(csvconfiguration.getUsers()), strategy);
            UserMapper mapper = new UserMapper(csvconfiguration.getDirectoryID(), userMapping, this.passwordHelper, csvconfiguration.isImportPasswords(), csvconfiguration.isEncryptPasswords());
            csvParser.getLine();
            String[] userline = csvParser.getLine();
            while (userline != null) {
                UserTemplateWithCredentialAndAttributes user = mapper.mapRow(userline);
                users.add(user);
                userline = csvParser.getLine();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return users;
    }
}

