/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.header;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualitySourceMediaType
extends MediaType {
    public static final String QUALITY_SOURCE_FACTOR = "qs";
    public static final int DEFAULT_QUALITY_SOURCE_FACTOR = 1000;
    private final int qs;

    public QualitySourceMediaType(String p, String s) {
        super(p, s);
        this.qs = 1000;
    }

    public QualitySourceMediaType(String p, String s, int qs, Map<String, String> parameters) {
        super(p, s, parameters);
        this.qs = qs;
    }

    public int getQualitySource() {
        return this.qs;
    }

    public static QualitySourceMediaType valueOf(HttpHeaderReader reader) throws ParseException {
        String v;
        reader.hasNext();
        String type = reader.nextToken();
        reader.nextSeparator('/');
        String subType = reader.nextToken();
        int qs = 1000;
        Map<String, String> parameters = null;
        if (reader.hasNext() && (parameters = HttpHeaderReader.readParameters(reader)) != null && (v = parameters.get(QUALITY_SOURCE_FACTOR)) != null) {
            try {
                qs = (int)((double)Float.valueOf(v).floatValue() * 1000.0);
            }
            catch (NumberFormatException ex) {
                ParseException pe = new ParseException("The quality source (qs) value, " + v + ", is not a valid value", 0);
                pe.initCause(ex);
            }
            if (qs < 0) {
                throw new ParseException("The quality source (qs) value, " + v + ", must be non-negative number", 0);
            }
        }
        return new QualitySourceMediaType(type, subType, qs, parameters);
    }
}

