/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.ProxyCreatorSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ProxyFactory
extends ProxyCreatorSupport
implements AopProxy {
    public ProxyFactory() {
    }

    public ProxyFactory(Object target) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        this.setInterfaces(ClassUtils.getAllInterfaces((Object)target));
        this.setTarget(target);
    }

    public ProxyFactory(Class[] proxyInterfaces) {
        this.setInterfaces(proxyInterfaces);
    }

    public ProxyFactory(Class proxyInterface, Interceptor interceptor) {
        this.addInterface(proxyInterface);
        this.addAdvice((Advice)interceptor);
    }

    public ProxyFactory(Class proxyInterface, TargetSource targetSource) {
        this.addInterface(proxyInterface);
        this.setTargetSource(targetSource);
    }

    public Object getProxy() {
        return this.createAopProxy().getProxy();
    }

    public Object getProxy(ClassLoader classLoader) {
        return this.createAopProxy().getProxy(classLoader);
    }

    public static Object getProxy(Class proxyInterface, Interceptor interceptor) {
        return new ProxyFactory(proxyInterface, interceptor).getProxy();
    }

    public static Object getProxy(Class proxyInterface, TargetSource targetSource) {
        return new ProxyFactory(proxyInterface, targetSource).getProxy();
    }

    public static Object getProxy(TargetSource targetSource) {
        if (targetSource.getTargetClass() == null) {
            throw new IllegalArgumentException("Cannot create class proxy for TargetSource with null target class");
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(targetSource);
        proxyFactory.setProxyTargetClass(true);
        return proxyFactory.getProxy();
    }
}

