/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.MultiTenantComponentFactory;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantComponentMapBuilder;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantManager;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;
import com.atlassian.multitenant.impl.MultiTenantComponentMapBuilderImpl;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Set;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTenantComponentFactoryImpl
implements MultiTenantComponentFactory {
    private static final Logger log = Logger.getLogger(MultiTenantComponentFactoryImpl.class);
    private final TenantReference tenantReference;
    private final MultiTenantManager manager;
    private final MultiTenantDatastore datastore;

    public MultiTenantComponentFactoryImpl(TenantReference tenantReference, MultiTenantManager manager, MultiTenantDatastore datastore) {
        this.tenantReference = tenantReference;
        this.manager = manager;
        this.datastore = datastore;
    }

    @Override
    public <C> MultiTenantComponentMapBuilder<C> createComponentMapBuilder(MultiTenantCreator<C> creator) {
        return new MultiTenantComponentMapBuilderImpl<C>(creator, this.tenantReference, this.manager);
    }

    @Override
    public <C> MultiTenantComponentMap<C> createComponentMap(MultiTenantCreator<C> creator) {
        return this.createComponentMapBuilder(creator).construct();
    }

    @Override
    public <C> Object createComponent(MultiTenantComponentMap<C> map, ClassLoader classLoader, Class<? super C> ... interfaces) {
        return this.createComponent(map, classLoader, Collections.<Method>emptySet(), interfaces);
    }

    @Override
    public <C> C createComponent(MultiTenantComponentMap<C> map, Class<C> inter) {
        return (C)this.createComponent(map, inter.getClassLoader(), inter);
    }

    @Override
    public <C> C createComponent(MultiTenantCreator<C> creator, Class<C> inter) {
        return this.createComponent(this.createComponentMap(creator), inter);
    }

    @Override
    public <C> C createComponent(Class<? extends C> clazz, Class<C> inter) {
        return this.createComponent(new SimpleInstantiationCreator(clazz), inter);
    }

    @Override
    public <C> C createComponent(MultiTenantComponentMap<C> map, Set<Method> invokeForAllMethods, Class<C> inter) {
        return (C)this.createComponent(map, inter.getClassLoader(), invokeForAllMethods, inter);
    }

    @Override
    public <C> Object createComponent(MultiTenantComponentMap<C> map, ClassLoader classLoader, Set<Method> invokeForAllMethods, Class<? super C> ... interfaces) {
        MultiTenantAwareInvocationHandler<C> handler = new MultiTenantAwareInvocationHandler<C>(map, invokeForAllMethods, this.tenantReference, this.manager);
        return Proxy.newProxyInstance(classLoader, interfaces, handler);
    }

    private <C> Enhancer createEnhancer(MultiTenantComponentMap<C> map, Class<C> superClass) {
        Enhancer enhancer = new Enhancer();
        MultiTenantAwareMethodInterceptor<C> interceptor = new MultiTenantAwareMethodInterceptor<C>(map, this.tenantReference, this.manager);
        enhancer.setSuperclass(superClass);
        enhancer.setCallback(interceptor);
        return enhancer;
    }

    @Override
    public <C> C createEnhancedComponent(MultiTenantCreator<C> creator, Class<C> superClass) {
        return this.createEnhancedComponent(this.createComponentMap(creator), superClass);
    }

    @Override
    public <C> C createEnhancedComponent(Class<C> superClass) {
        return this.createEnhancedComponent(new SimpleInstantiationCreator(superClass), superClass);
    }

    @Override
    public <C> C createEnhancedComponent(MultiTenantComponentMap<C> map, Class superClass) {
        return (C)this.createEnhancer(map, superClass).create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleInstantiationCreator<C>
    implements MultiTenantCreator<C> {
        private final Class<? extends C> clazz;

        private SimpleInstantiationCreator(Class<? extends C> clazz) {
            this.clazz = clazz;
        }

        @Override
        public C create(Tenant tenant) {
            try {
                return this.clazz.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("Unable to instantiate class", iae);
            }
            catch (InstantiationException ie) {
                throw new IllegalArgumentException("Unable to instantiate class", ie);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiTenantAwareMethodInterceptor<C>
    extends AbstractMultiTenantAwareInvocationHandler<C>
    implements MethodInterceptor {
        public MultiTenantAwareMethodInterceptor(MultiTenantComponentMap<C> map, TenantReference tenantReference, MultiTenantManager manager) {
            super(map, tenantReference, manager);
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return this.invokeInternal(method, args, obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiTenantAwareInvocationHandler<C>
    extends AbstractMultiTenantAwareInvocationHandler<C>
    implements InvocationHandler {
        public MultiTenantAwareInvocationHandler(MultiTenantComponentMap<C> map, Set<Method> invokeForAllMethods, TenantReference tenantReference, MultiTenantManager manager) {
            super(map, invokeForAllMethods, tenantReference, manager);
        }

        public MultiTenantAwareInvocationHandler(MultiTenantComponentMap<C> map, TenantReference tenantReference, MultiTenantManager manager) {
            this(map, Collections.emptySet(), tenantReference, manager);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.invokeInternal(method, args, proxy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractMultiTenantAwareInvocationHandler<C> {
        private final MultiTenantComponentMap<C> map;
        private final Set<Method> invokeForAllMethods;
        private final TenantReference tenantReference;
        private final MultiTenantManager manager;

        private AbstractMultiTenantAwareInvocationHandler(MultiTenantComponentMap<C> map, Set<Method> invokeForAllMethods, TenantReference tenantReference, MultiTenantManager manager) {
            this.map = map;
            this.invokeForAllMethods = invokeForAllMethods;
            this.tenantReference = tenantReference;
            this.manager = manager;
        }

        private AbstractMultiTenantAwareInvocationHandler(MultiTenantComponentMap<C> map, TenantReference tenantReference, MultiTenantManager manager) {
            this(map, Collections.emptySet(), tenantReference, manager);
        }

        protected Object invokeInternal(final Method method, final Object[] args, Object proxyObject) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                if (method.getName().equals("equals")) {
                    return proxyObject == args[0];
                }
                if (method.getName().equals("toString")) {
                    return "Multi-Tenant proxy for " + this.map.toString();
                }
                if (method.getName().equals("hashCode")) {
                    return this.hashCode();
                }
            }
            if (this.invokeForAllMethods.contains(method) && !this.tenantReference.isSet()) {
                this.manager.runForEachTenant(new Runnable(){

                    public void run() {
                        Object component = AbstractMultiTenantAwareInvocationHandler.this.map.get();
                        try {
                            method.invoke(component, args);
                        }
                        catch (Exception e) {
                            log.error((Object)"Error invoking invoke for all method on tenant", (Throwable)e);
                        }
                    }
                });
                return null;
            }
            C component = this.map.get();
            try {
                return method.invoke(component, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
    }
}

