/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.model.application.RemoteAddress;
import java.util.Arrays;
import sun.net.util.IPAddressUtil;

public class RemoteAddressHelper {
    public static boolean isAddressAllowed(RemoteAddress allowedAddress, RemoteAddress requestAddress) {
        if (requestAddress.isHostName() && allowedAddress.isHostName()) {
            return allowedAddress.getAddress().equals(requestAddress.getAddress());
        }
        if (!requestAddress.isHostName() && !allowedAddress.isHostName()) {
            byte[] requestIpAddress;
            int nMaskBits = allowedAddress.getMask();
            int oddBits = nMaskBits % 8;
            int nMaskBytes = nMaskBits / 8 + (oddBits == 0 ? 0 : 1);
            byte[] mask = new byte[nMaskBytes];
            byte[] allowedIpAddress = allowedAddress.getAddressBytes();
            if (allowedIpAddress.length != (requestIpAddress = requestAddress.getAddressBytes()).length) {
                return false;
            }
            if (nMaskBits == 0) {
                return Arrays.equals(allowedIpAddress, requestIpAddress);
            }
            Arrays.fill(mask, 0, oddBits == 0 ? mask.length : mask.length - 1, (byte)-1);
            if (oddBits != 0) {
                int finalByte = (1 << oddBits) - 1;
                mask[mask.length - 1] = (byte)(finalByte <<= 8 - oddBits);
            }
            for (int i = 0; i < mask.length; ++i) {
                if ((allowedIpAddress[i] & mask[i]) == (requestIpAddress[i] & mask[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] getAddressInBytes(String address) {
        boolean ipv6Expected = false;
        if (address.charAt(0) == '[') {
            if (address.length() > 2 && address.charAt(address.length() - 1) == ']') {
                address = address.substring(1, address.length() - 1);
                ipv6Expected = true;
            } else {
                return null;
            }
        }
        if (Character.digit(address.charAt(0), 16) != -1 || address.charAt(0) == ':') {
            byte[] addr = null;
            addr = IPAddressUtil.textToNumericFormatV4(address);
            if (addr == null) {
                addr = IPAddressUtil.textToNumericFormatV6(address);
            } else if (ipv6Expected) {
                return null;
            }
            if (addr != null) {
                return addr;
            }
        } else if (ipv6Expected) {
            return null;
        }
        return null;
    }

    public static boolean isValidIPNotation(String address) {
        String addr = address;
        if (address.contains("/")) {
            String[] addressComponents = address.split("/");
            addr = addressComponents[0];
        }
        return RemoteAddressHelper.getAddressInBytes(addr) != null;
    }
}

