/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xwork.interceptors;

import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class RestrictHttpMethodInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(RestrictHttpMethodInterceptor.class);
    public static final String INVALID_METHOD_RESULT = "invalidmethod";
    public static final String PERMITTED_METHODS_PARAM_NAME = "permittedMethods";

    public final String intercept(ActionInvocation invocation) throws Exception {
        Method invocationMethod = invocation.getProxy().getConfig().getMethod();
        String configParam = (String)invocation.getProxy().getConfig().getParams().get(PERMITTED_METHODS_PARAM_NAME);
        PermittedMethods annotation = invocationMethod.getAnnotation(PermittedMethods.class);
        HttpMethod[] permittedMethods = this.toPermittedMethodArray(configParam, annotation);
        String httpMethod = this.getHttpMethod();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking HTTP method: " + this.getHttpMethod() + " permitted against " + this.fullMethodName(invocationMethod)));
        }
        if (this.getSecurityLevel().isPermitted(invocationMethod.getName(), permittedMethods, httpMethod)) {
            log.debug((Object)"Invocation proceeding");
            return invocation.invoke();
        }
        log.info((Object)("Refusing HTTP method: " + httpMethod + " against " + this.fullMethodName(invocationMethod) + " (configured allowed methods: " + Arrays.toString((Object[])permittedMethods) + ")"));
        return INVALID_METHOD_RESULT;
    }

    private HttpMethod[] toPermittedMethodArray(String configParam, PermittedMethods annotation) {
        if (configParam != null && configParam.trim().length() > 0) {
            String[] methodNames = configParam.trim().split("\\s*,\\s*");
            ArrayList<HttpMethod> permittedMethods = new ArrayList<HttpMethod>(methodNames.length);
            for (String methodName : methodNames) {
                try {
                    permittedMethods.add(HttpMethod.valueOf(methodName));
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("XWork configuration error: " + methodName + " is not a recognised HTTP method (method names are case sensitive)."));
                }
            }
            return permittedMethods.toArray(new HttpMethod[permittedMethods.size()]);
        }
        if (annotation != null) {
            return annotation.value();
        }
        return new HttpMethod[0];
    }

    private String fullMethodName(Method invocationMethod) {
        return invocationMethod.getDeclaringClass().getName() + "#" + invocationMethod.getName();
    }

    private String getHttpMethod() {
        HttpServletRequest servletRequest = ServletActionContext.getRequest();
        return servletRequest == null ? "" : servletRequest.getMethod();
    }

    public final void destroy() {
    }

    public final void init() {
    }

    protected SecurityLevel getSecurityLevel() {
        return SecurityLevel.DEFAULT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecurityLevel {
        NONE{

            public boolean isPermitted(String invocationMethodName, HttpMethod[] permittedMethods, String httpMethod) {
                return true;
            }
        }
        ,
        OPT_IN{

            public boolean isPermitted(String invocationMethodName, HttpMethod[] permittedMethods, String httpMethod) {
                if (permittedMethods.length == 0) {
                    return true;
                }
                return SecurityLevel.methodMatches(httpMethod, permittedMethods);
            }
        }
        ,
        DEFAULT{

            public boolean isPermitted(String invocationMethodName, HttpMethod[] permittedMethods, String httpMethod) {
                if (permittedMethods.length == 0) {
                    if (invocationMethodName.equals("doDefault")) {
                        return SecurityLevel.methodMatches(httpMethod, new HttpMethod[]{HttpMethod.GET, HttpMethod.POST});
                    }
                    return SecurityLevel.methodMatches(httpMethod, new HttpMethod[]{HttpMethod.POST});
                }
                return SecurityLevel.methodMatches(httpMethod, permittedMethods);
            }
        }
        ,
        STRICT{

            public boolean isPermitted(String invocationMethodName, HttpMethod[] permittedMethods, String httpMethod) {
                return SecurityLevel.methodMatches(httpMethod, permittedMethods);
            }
        };


        private static boolean methodMatches(String httpMethod, HttpMethod ... allowedMethods) {
            for (HttpMethod allowedMethod : allowedMethods) {
                if (!allowedMethod.matches(httpMethod)) continue;
                return true;
            }
            return false;
        }

        public abstract boolean isPermitted(String var1, HttpMethod[] var2, String var3);
    }
}

