/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xwork;

import com.atlassian.xwork.XsrfTokenGenerator;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SimpleXsrfTokenGenerator
implements XsrfTokenGenerator {
    public static final String TOKEN_SESSION_KEY = "atlassian.xsrf.token";
    private static Random random = new Random();

    public String generateToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String token = (String)session.getAttribute(TOKEN_SESSION_KEY);
        if (token == null) {
            token = this.createToken();
            session.setAttribute(TOKEN_SESSION_KEY, (Object)token);
        }
        return token;
    }

    public String getXsrfTokenName() {
        return "atl_token";
    }

    public boolean validateToken(HttpServletRequest request, String token) {
        return token != null && token.equals(request.getSession(true).getAttribute(TOKEN_SESSION_KEY));
    }

    private synchronized String createToken() {
        return SimpleEncoder.encode(random.nextLong());
    }

    private static class SimpleEncoder {
        private static final char[] MAPPING = new char[64];

        private SimpleEncoder() {
        }

        public static String encode(long l) {
            char[] out = new char[10];
            for (int i = 0; i < 10; ++i) {
                out[i] = MAPPING[(int)(l & 0x3FL)];
                l >>>= 6;
            }
            return new String(out);
        }

        static {
            int i = 0;
            int c = 65;
            while (c <= 90) {
                SimpleEncoder.MAPPING[i] = c;
                c = (char)(c + 1);
                ++i;
            }
            c = 97;
            while (c <= 122) {
                SimpleEncoder.MAPPING[i] = c;
                c = (char)(c + 1);
                ++i;
            }
            c = 48;
            while (c <= 57) {
                SimpleEncoder.MAPPING[i] = c;
                c = (char)(c + 1);
                ++i;
            }
            SimpleEncoder.MAPPING[62] = 95;
            SimpleEncoder.MAPPING[63] = 45;
        }
    }
}

